<!-- Sidebar -->
<div class="zSidebar" data-background="{{ asset('assets/images/sidebar-bg.png') }}">
    <div class="zSidebar-overlay"></div>
    <!-- Logo -->
    <a href="{{ route('index') }}" class="d-block mx-26 mb-27 max-w-146 pt-23">
        @if(centralDomain() && isAddonInstalled('ALUSAAS'))
        <img class="max-h-35" src="{{ getSettingImageCentral('app_logo') }}" alt="{{ getOption('app_name') }}"/>
        @else
        <img class="max-h-35" src="{{ getSettingImage('app_logo') }}" alt="{{ getOption('app_name') }}"/>
        @endif
    </a>
    <!-- Menu & Logout -->
    <div class="zSidebar-fixed">
        <ul class="zSidebar-menu" id="sidebarMenu">
            @if (auth()->user()->role == USER_ROLE_ADMIN)
                <li>
                    <a href="{{ route('admin.dashboard') }}"
                       class="{{ $activeDashboard ?? '' }} d-flex align-items-center cg-10">
                        <div class="d-flex">
                            <svg width="25" height="24" viewBox="0 0 25 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M6.88979 10.3929C6.14657 10.3929 5.62851 10.3924 5.22349 10.3635C4.82565 10.3351 4.59466 10.2819 4.4186 10.2051C3.89833 9.97813 3.48308 9.56288 3.25609 9.04261C3.17928 8.86655 3.12616 8.63556 3.09774 8.23773C3.0688 7.83271 3.06836 7.31465 3.06836 6.57143C3.06836 5.82821 3.0688 5.31015 3.09774 4.90513C3.12616 4.50729 3.17928 4.2763 3.25609 4.10024C3.48308 3.57997 3.89833 3.16473 4.4186 2.93773C4.59466 2.86092 4.82565 2.80781 5.22349 2.77938C5.6285 2.75045 6.14657 2.75 6.88979 2.75C7.63301 2.75 8.15107 2.75045 8.55609 2.77938C8.95392 2.80781 9.18491 2.86092 9.36097 2.93773C9.88124 3.16473 10.2965 3.57997 10.5235 4.10024C10.6003 4.2763 10.6534 4.50729 10.6818 4.90513C10.7108 5.31015 10.7112 5.82821 10.7112 6.57143C10.7112 7.31465 10.7108 7.83271 10.6818 8.23773C10.6534 8.63556 10.6003 8.86655 10.5235 9.04261C10.2965 9.56288 9.88124 9.97813 9.36097 10.2051C9.18491 10.2819 8.95392 10.3351 8.55609 10.3635C8.15107 10.3924 7.63301 10.3929 6.88979 10.3929Z"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5"/>
                                <path
                                    d="M6.88979 21.25C6.14657 21.25 5.62851 21.2496 5.22349 21.2207C4.82565 21.1922 4.59466 21.1391 4.4186 21.0623C3.89833 20.8353 3.48308 20.4201 3.25609 19.8998C3.17928 19.7237 3.12616 19.4927 3.09774 19.0949C3.0688 18.6899 3.06836 18.1718 3.06836 17.4286C3.06836 16.6854 3.0688 16.1673 3.09774 15.7623C3.12616 15.3645 3.17928 15.1335 3.25609 14.9574C3.48308 14.4372 3.89833 14.0219 4.4186 13.7949C4.59466 13.7181 4.82565 13.665 5.22349 13.6366C5.6285 13.6076 6.14657 13.6072 6.88979 13.6072C7.63301 13.6072 8.15107 13.6076 8.55609 13.6366C8.95392 13.665 9.18491 13.7181 9.36097 13.7949C9.88124 14.0219 10.2965 14.4372 10.5235 14.9574C10.6003 15.1335 10.6534 15.3645 10.6818 15.7623C10.7108 16.1673 10.7112 16.6854 10.7112 17.4286C10.7112 18.1718 10.7108 18.6899 10.6818 19.0949C10.6534 19.4927 10.6003 19.7237 10.5235 19.8998C10.2965 20.4201 9.88124 20.8353 9.36097 21.0623C9.18491 21.1391 8.95392 21.1922 8.55609 21.2207C8.15107 21.2496 7.63301 21.25 6.88979 21.25Z"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5"/>
                                <path
                                    d="M17.7472 10.3929C17.004 10.3929 16.4859 10.3924 16.0809 10.3635C15.6831 10.3351 15.4521 10.2819 15.276 10.2051C14.7558 9.97813 14.3405 9.56288 14.1135 9.04261C14.0367 8.86655 13.9836 8.63556 13.9552 8.23773C13.9262 7.83271 13.9258 7.31465 13.9258 6.57143C13.9258 5.82821 13.9262 5.31015 13.9552 4.90513C13.9836 4.50729 14.0367 4.2763 14.1135 4.10024C14.3405 3.57997 14.7558 3.16473 15.276 2.93773C15.4521 2.86092 15.6831 2.80781 16.0809 2.77938C16.4859 2.75045 17.004 2.75 17.7472 2.75C18.4904 2.75 19.0085 2.75045 19.4135 2.77938C19.8113 2.80781 20.0423 2.86092 20.2184 2.93773C20.7387 3.16473 21.1539 3.57997 21.3809 4.10024C21.4577 4.2763 21.5108 4.50729 21.5393 4.90513C21.5682 5.31015 21.5686 5.82821 21.5686 6.57143C21.5686 7.31465 21.5682 7.83271 21.5393 8.23773C21.5108 8.63556 21.4577 8.86655 21.3809 9.04261C21.1539 9.56288 20.7387 9.97813 20.2184 10.2051C20.0423 10.2819 19.8113 10.3351 19.4135 10.3635C19.0085 10.3924 18.4904 10.3929 17.7472 10.3929Z"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5"/>
                                <path
                                    d="M17.7472 21.25C17.004 21.25 16.4859 21.2496 16.0809 21.2207C15.6831 21.1922 15.4521 21.1391 15.276 21.0623C14.7558 20.8353 14.3405 20.4201 14.1135 19.8998C14.0367 19.7237 13.9836 19.4927 13.9552 19.0949C13.9262 18.6899 13.9258 18.1718 13.9258 17.4286C13.9258 16.6854 13.9262 16.1673 13.9552 15.7623C13.9836 15.3645 14.0367 15.1335 14.1135 14.9574C14.3405 14.4372 14.7558 14.0219 15.276 13.7949C15.4521 13.7181 15.6831 13.665 16.0809 13.6366C16.4859 13.6076 17.004 13.6072 17.7472 13.6072C18.4904 13.6072 19.0085 13.6076 19.4135 13.6366C19.8113 13.665 20.0423 13.7181 20.2184 13.7949C20.7387 14.0219 21.1539 14.4372 21.3809 14.9574C21.4577 15.1335 21.5108 15.3645 21.5393 15.7623C21.5682 16.1673 21.5686 16.6854 21.5686 17.4286C21.5686 18.1718 21.5682 18.6899 21.5393 19.0949C21.5108 19.4927 21.4577 19.7237 21.3809 19.8998C21.1539 20.4201 20.7387 20.8353 20.2184 21.0623C20.0423 21.1391 19.8113 21.1922 19.4135 21.2207C19.0085 21.2496 18.4904 21.25 17.7472 21.25Z"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Dashboard') }}</span>
                    </a>
                </li>
            @endif

            @if(!isCentralDomain() || !isAddonInstalled('ALUSAAS'))
                <li>
                    <a href="{{ route('home') }}" class="{{ $activeHome ?? '' }} d-flex align-items-center cg-10">
                        <div class="d-flex">
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="20" viewBox="0 0 22 20"
                                 fill="none">
                                <path d="M1.71387 11.4286L10.9996 2.14285L20.2853 11.4286" stroke="white"
                                      stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <path d="M4.57129 8.57144L4.57129 17.8572H17.4284V8.57144" stroke="white"
                                      stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Home') }}</span>
                    </a>
                </li>
                <li>
                    <a href="#myEvent" data-bs-toggle="collapse" role="button" aria-controls="myEvent"
                       class="d-flex align-items-center cg-10 {{ isset($showEvent) ? 'active' : 'collapsed' }}"
                       aria-expanded="{{ isset($showEvent) ? 'true' : 'false' }}">
                        <div class="d-flex">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <rect x="3" y="6" width="18" height="15" rx="2"
                                      stroke="white" stroke-width="1.5"/>
                                <path d="M4 11H20" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M9 16H15" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M8 3L8 7" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M16 3L16 7" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                            </svg>
                        </div>
                        <span class="">{{ __('My Event') }}</span>
                    </a>
                    <div class="collapse {{ $showEvent ?? '' }}" id="myEvent" data-bs-parent="#sidebarMenu">
                        <ul class="zSidebar-submenu">
                            @if (auth()->user()->role == USER_ROLE_ADMIN)
                                <li><a class="{{ $activeEventCategory ?? '' }}"
                                       href="{{ route('admin.event.category.index') }}">{{ __('Event Category') }}</a>
                                </li>
                                <li><a class="{{ $activeEventPending ?? '' }}"
                                       href="{{ route('admin.event.pending.index') }}">{{ __('Pending Event') }}</a>
                                </li>
                            @endif
                            <li><a class="{{ $activeEventCreate ?? '' }}"
                                   href="{{ route('event.create') }}">{{ __('Create Event') }}</a>
                            </li>
                            <li><a class="{{ $activeMyEvent ?? '' }}"
                                   href="{{ route('event.my-event') }}">{{ __('My Event') }}</a>
                            </li>
                            <li><a class="{{ $activeAllEvent ?? '' }}"
                                   href="{{ route('event.all') }}">{{ __('All Event') }}</a>
                            </li>
                            <li><a class="{{ $activeTicket ?? '' }}"
                                   href="{{ route('event.my-ticket') }}">{{ __('My Ticket') }}</a>
                            </li>
                        </ul>
                    </div>
                </li>
                <li>
                    <a href="#jobPost" data-bs-toggle="collapse" role="button"
                       aria-expanded="{{ isset($showJobPostManagement) ? 'true' : '' }}" aria-controls="jobPost"
                       class="d-flex align-items-center cg-10 {{ isset($showJobPostManagement) ? 'active' : 'collapsed' }}">
                        <div class="d-flex">
                            <svg width="25" height="26" viewBox="0 0 25 26" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <rect x="5.20801" y="5.11185" width="14.5833" height="17.7083" rx="2"
                                      stroke="white" stroke-opacity="0.7" stroke-width="1.5"/>
                                <path d="M9.375 10.3202H15.625" stroke="white" stroke-opacity="0.7" stroke-width="1.5"
                                      stroke-linecap="round"/>
                                <path d="M9.375 14.4868H15.625" stroke="white" stroke-opacity="0.7" stroke-width="1.5"
                                      stroke-linecap="round"/>
                                <path d="M9.375 18.6535H13.5417" stroke="white" stroke-opacity="0.7" stroke-width="1.5"
                                      stroke-linecap="round"/>
                            </svg>
                        </div>
                        <span class="">{{__('Job Post')}}</span>
                    </a>
                    <div class="collapse {{ $showJobPostManagement ?? '' }}" id="jobPost"
                         data-bs-parent="#sidebarMenu">
                        <ul class="zSidebar-submenu">
                            <li><a class="{{ $activeJobPostCreate ?? '' }}"
                                   href="{{ route('jobPost.create') }}">{{ __('Create Post') }}</a></li>
                            @if (auth()->user()->role == USER_ROLE_ADMIN)
                                <li><a class="{{ $activePendingJobPostList ?? '' }}"
                                       href="{{ route('admin.jobPost.pending-job-post') }}">{{ __('Pending Post') }}</a>
                                </li>
                            @endif
                            <li><a class="{{ $activeMyJobPostList ?? '' }}"
                                   href="{{ route('jobPost.my-job-post') }}">{{ __('My Post') }}</a></li>
                            <li><a class="{{ $activeAllJobPostList ?? '' }}"
                                   href="{{ route('jobPost.all-job-post') }}">{{ __('All Post') }}</a></li>
                        </ul>
                    </div>
                </li>
                <li>
                    <a href="#storyMenu" data-bs-toggle="collapse" role="button"
                       aria-expanded="{{ isset($showStoryManagement) ? 'true' : '' }}" aria-controls="storyMenu"
                       class="d-flex align-items-center cg-10 {{ isset($showStoryManagement) ? 'active' : 'collapsed' }}">
                        <div class="d-flex">
                            <svg xmlns="http://www.w3.org/2000/svg" width="25" height="26" viewBox="0 0 25 26"
                                 fill="none">
                                <path
                                    d="M20.0934 4.00108L20.1195 4.75063V4.75063L20.0934 4.00108ZM16.7072 4.4451L16.4921 3.72661V3.72661L16.7072 4.4451ZM14.0356 5.6885L13.6599 5.03937L13.6599 5.03937L14.0356 5.6885ZM4.87402 4.0551L4.82801 4.80369L4.87402 4.0551ZM7.72663 4.4451L7.91799 3.71992L7.91799 3.71992L7.72663 4.4451ZM10.8294 5.75723L10.4788 6.42024L10.8294 5.75723ZM13.9919 20.1203L14.3447 20.7822L13.9919 20.1203ZM17.1799 18.7629L16.9885 18.0378L17.1799 18.7629ZM20.0018 18.3748L20.0487 19.1234L20.0018 18.3748ZM10.9147 20.1203L10.5619 20.7822H10.5619L10.9147 20.1203ZM7.72663 18.7629L7.91799 18.0378H7.91799L7.72663 18.7629ZM4.9047 18.3748L4.85788 19.1234H4.85788L4.9047 18.3748ZM3.75 16.4093V5.87288H2.25V16.4093H3.75ZM22.6565 16.4093V5.81181H21.1565V16.4093H22.6565ZM20.0673 3.25154C18.9906 3.28904 17.5796 3.40106 16.4921 3.72661L16.9223 5.16359C17.8143 4.89658 19.0624 4.78745 20.1195 4.75063L20.0673 3.25154ZM16.4921 3.72661C15.5467 4.00964 14.4853 4.56168 13.6599 5.03937L14.4113 6.33762C15.2146 5.87269 16.1517 5.39429 16.9223 5.16359L16.4921 3.72661ZM4.82801 4.80369C5.74061 4.85978 6.77153 4.96874 7.53527 5.17028L7.91799 3.71992C7.00565 3.47917 5.8534 3.36388 4.92003 3.30651L4.82801 4.80369ZM7.53527 5.17028C8.44003 5.40902 9.55596 5.93224 10.4788 6.42024L11.18 5.09421C10.2385 4.59634 8.99693 4.00463 7.91799 3.71992L7.53527 5.17028ZM14.3447 20.7822C15.281 20.283 16.4378 19.7344 17.3713 19.4881L16.9885 18.0378C15.8773 18.331 14.5924 18.9503 13.6391 19.4585L14.3447 20.7822ZM17.3713 19.4881C18.1263 19.2889 19.1429 19.18 20.0487 19.1234L19.955 17.6263C19.0279 17.6843 17.891 17.7996 16.9885 18.0378L17.3713 19.4881ZM11.2675 19.4585C10.3142 18.9503 9.02921 18.331 7.91799 18.0378L7.53527 19.4881C8.46871 19.7344 9.6255 20.283 10.5619 20.7822L11.2675 19.4585ZM7.91799 18.0378C7.01549 17.7996 5.8786 17.6843 4.95152 17.6263L4.85788 19.1234C5.76364 19.18 6.78023 19.2889 7.53527 19.4881L7.91799 18.0378ZM21.1565 16.4093C21.1565 17.0343 20.6378 17.5836 19.955 17.6263L20.0487 19.1234C21.4623 19.035 22.6565 17.8848 22.6565 16.4093H21.1565ZM22.6565 5.81181C22.6565 4.40713 21.5375 3.20032 20.0673 3.25154L20.1195 4.75063C20.6757 4.73125 21.1565 5.18885 21.1565 5.81181H22.6565ZM2.25 16.4093C2.25 17.8848 3.44425 19.035 4.85788 19.1234L4.95152 17.6263C4.26877 17.5836 3.75 17.0343 3.75 16.4093H2.25ZM13.6391 19.4585C12.9022 19.8513 12.0044 19.8513 11.2675 19.4585L10.5619 20.7822C11.7398 21.4101 13.1667 21.4101 14.3447 20.7822L13.6391 19.4585ZM13.6599 5.03937C12.8986 5.47998 11.9509 5.50181 11.18 5.09421L10.4788 6.42024C11.7131 7.07288 13.2095 7.03314 14.4113 6.33762L13.6599 5.03937ZM3.75 5.87288C3.75 5.23574 4.25397 4.76841 4.82801 4.80369L4.92003 3.30651C3.42171 3.21443 2.25 4.43377 2.25 5.87288H3.75Z"
                                    fill="white" fill-opacity="0.7"/>
                                <path d="M12.4531 6.68213V21" stroke="white" stroke-opacity="0.7" stroke-width="1.5"/>
                                <path d="M5.83594 9.65613L9.61725 10.6015" stroke="white" stroke-opacity="0.7"
                                      stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M5.83594 13.4375L9.61725 14.3828" stroke="white" stroke-opacity="0.7"
                                      stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M19.0703 13.4375L15.289 14.3828" stroke="white" stroke-opacity="0.7"
                                      stroke-width="1.5" stroke-linecap="round"/>
                                <path
                                    d="M19.0704 6.34753V10.1386C19.0704 10.3991 19.0704 10.5293 18.9807 10.582C18.891 10.6346 18.7684 10.5764 18.5231 10.4599L17.3488 9.90207C17.2658 9.86265 17.2243 9.84294 17.1797 9.84294C17.1351 9.84294 17.0936 9.86265 17.0106 9.90207L15.8363 10.4599C15.591 10.5764 15.4684 10.6346 15.3787 10.582C15.2891 10.5293 15.2891 10.3991 15.2891 10.1386V7.71828"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"/>
                            </svg>
                        </div>
                        <span class="">{{__('Stories')}}</span>
                    </a>
                    <div class="collapse {{ $showStoryManagement ?? '' }}" id="storyMenu"
                         data-bs-parent="#sidebarMenu">
                        <ul class="zSidebar-submenu">
                            <li><a class="{{ $activeStoryCreate ?? '' }}"
                                   href="{{ route('stories.create') }}">{{ __('Create Story') }}</a></li>
                            @if (auth()->user()->role == USER_ROLE_ADMIN)
                                <li><a class="{{ $activePendingStoryList ?? '' }}"
                                       href="{{ route('admin.stories.pending') }}">{{ __('Pending Story') }}</a>
                                </li>
                            @endif
                            <li><a class="{{ $activeMyStoryList ?? '' }}"
                                   href="{{ route('stories.my-story') }}">{{ __('My Story') }}</a></li>
                            <li><a target="_blank" href="{{ route('all.stories') }}">{{ __('All Story') }}</a></li>
                        </ul>
                    </div>
                </li>
                <li>
                    <a href="{{ route('alumni.list-search-with-filter') }}"
                       class="{{ $activeAlumniList ?? '' }} d-flex align-items-center cg-10">
                        <div class="d-flex">
                            <svg width="25" height="18" viewBox="0 0 25 18" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M23.9065 10.6875C23.8245 10.7491 23.7311 10.7939 23.6317 10.8193C23.5323 10.8448 23.4289 10.8504 23.3273 10.8359C23.2257 10.8214 23.128 10.787 23.0398 10.7348C22.9515 10.6825 22.8744 10.6133 22.8128 10.5313C22.3419 9.89831 21.729 9.38477 21.0234 9.03196C20.3178 8.67916 19.5392 8.49695 18.7503 8.50001C18.5967 8.5 18.4464 8.45469 18.3184 8.36975C18.1904 8.28481 18.0903 8.16402 18.0306 8.02247C17.99 7.92635 17.9691 7.82309 17.9691 7.71876C17.9691 7.61444 17.99 7.51117 18.0306 7.41505C18.0903 7.2735 18.1904 7.15271 18.3184 7.06777C18.4464 6.98283 18.5967 6.93753 18.7503 6.93751C19.1886 6.93747 19.6182 6.8145 19.9902 6.58257C20.3621 6.35064 20.6616 6.01904 20.8546 5.62544C21.0475 5.23184 21.1262 4.79202 21.0817 4.35593C21.0373 3.91984 20.8714 3.50497 20.6029 3.15843C20.3345 2.8119 19.9742 2.54759 19.5631 2.39554C19.152 2.24348 18.7064 2.20977 18.2771 2.29824C17.8478 2.3867 17.4518 2.5938 17.1343 2.896C16.8168 3.1982 16.5903 3.58339 16.4808 4.00782C16.4551 4.10721 16.4101 4.20058 16.3484 4.28258C16.2867 4.36459 16.2094 4.43364 16.121 4.48578C16.0326 4.53792 15.9347 4.57214 15.8331 4.58648C15.7315 4.60082 15.628 4.595 15.5286 4.56935C15.4292 4.5437 15.3359 4.49872 15.2539 4.43699C15.1718 4.37526 15.1028 4.29798 15.0507 4.20957C14.9985 4.12115 14.9643 4.02333 14.95 3.92169C14.9356 3.82006 14.9414 3.71659 14.9671 3.6172C15.1192 3.02864 15.4066 2.4837 15.8063 2.02575C16.2061 1.56779 16.7072 1.20946 17.2699 0.97926C17.8325 0.749062 18.4411 0.653353 19.0472 0.699748C19.6533 0.746143 20.2403 0.933362 20.7613 1.24651C21.2823 1.55965 21.7231 1.99008 22.0485 2.50354C22.3739 3.01701 22.575 3.59933 22.6358 4.20419C22.6965 4.80904 22.6153 5.41973 22.3985 5.98766C22.1817 6.55558 21.8354 7.06508 21.387 7.4756C22.4493 7.93555 23.3728 8.66545 24.0657 9.59278C24.1273 9.67507 24.172 9.76869 24.1973 9.86828C24.2226 9.96787 24.228 10.0715 24.2133 10.1732C24.1985 10.2749 24.1638 10.3726 24.1111 10.4609C24.0585 10.5492 23.989 10.6262 23.9065 10.6875ZM18.6448 16.7031C18.7014 16.7921 18.7393 16.8915 18.7564 16.9955C18.7735 17.0994 18.7694 17.2058 18.7443 17.3081C18.7193 17.4105 18.6738 17.5067 18.6105 17.591C18.5473 17.6753 18.4677 17.7459 18.3765 17.7986C18.2853 17.8514 18.1843 17.8851 18.0797 17.8978C17.9751 17.9105 17.869 17.9019 17.7678 17.8726C17.6666 17.8432 17.5724 17.7937 17.4909 17.727C17.4093 17.6603 17.3421 17.5777 17.2933 17.4844C16.8011 16.6511 16.1002 15.9604 15.2597 15.4807C14.4192 15.0009 13.4681 14.7486 12.5003 14.7486C11.5325 14.7486 10.5814 15.0009 9.74089 15.4807C8.90038 15.9604 8.19947 16.6511 7.70732 17.4844C7.65848 17.5777 7.59126 17.6603 7.50971 17.727C7.42815 17.7937 7.33394 17.8432 7.23274 17.8726C7.13155 17.9019 7.02546 17.9105 6.92087 17.8978C6.81627 17.8851 6.71532 17.8514 6.6241 17.7986C6.53288 17.7459 6.45326 17.6753 6.39005 17.591C6.32683 17.5067 6.28132 17.4105 6.25625 17.3081C6.23119 17.2058 6.22708 17.0994 6.24418 16.9955C6.26128 16.8915 6.29924 16.7921 6.35576 16.7031C7.11318 15.4017 8.26806 14.3776 9.65068 13.7813C8.87268 13.1856 8.30091 12.3611 8.01572 11.4237C7.73054 10.4862 7.74629 9.48301 8.06076 8.555C8.37522 7.62698 8.9726 6.82084 9.76892 6.24989C10.5652 5.67894 11.5204 5.37188 12.5003 5.37188C13.4801 5.37188 14.4354 5.67894 15.2317 6.24989C16.028 6.82084 16.6254 7.62698 16.9398 8.555C17.2543 9.48301 17.27 10.4862 16.9849 11.4237C16.6997 12.3611 16.1279 13.1856 15.3499 13.7813C16.7325 14.3776 17.8874 15.4017 18.6448 16.7031ZM12.5003 13.1875C13.1184 13.1875 13.7225 13.0042 14.2365 12.6609C14.7504 12.3175 15.1509 11.8294 15.3874 11.2584C15.6239 10.6874 15.6858 10.059 15.5652 9.45285C15.4447 8.84666 15.147 8.28984 14.71 7.8528C14.273 7.41576 13.7161 7.11814 13.11 6.99756C12.5038 6.87698 11.8754 6.93886 11.3044 7.17539C10.7334 7.41191 10.2453 7.81245 9.90195 8.32635C9.55857 8.84026 9.37529 9.44444 9.37529 10.0625C9.37529 10.8913 9.70453 11.6862 10.2906 12.2722C10.8766 12.8583 11.6715 13.1875 12.5003 13.1875ZM7.03154 7.71876C7.03154 7.51156 6.94923 7.31285 6.80272 7.16633C6.65621 7.01982 6.45749 6.93751 6.25029 6.93751C5.81194 6.93747 5.38239 6.8145 5.01042 6.58257C4.63845 6.35064 4.33898 6.01904 4.14603 5.62544C3.95307 5.23184 3.87437 4.79202 3.91885 4.35593C3.96333 3.91984 4.12921 3.50497 4.39766 3.15843C4.66611 2.8119 5.02637 2.54759 5.4375 2.39554C5.84863 2.24348 6.29417 2.20977 6.7235 2.29824C7.15283 2.3867 7.54875 2.5938 7.86628 2.896C8.18382 3.1982 8.41024 3.58339 8.51982 4.00782C8.57162 4.20855 8.70104 4.38048 8.8796 4.48578C9.05817 4.59109 9.27125 4.62115 9.47197 4.56935C9.6727 4.51755 9.84462 4.38813 9.94993 4.20957C10.0552 4.03101 10.0853 3.81792 10.0335 3.6172C9.88139 3.02864 9.59402 2.4837 9.19425 2.02575C8.79448 1.56779 8.29334 1.20946 7.73072 0.97926C7.16809 0.749062 6.5595 0.653353 5.95338 0.699748C5.34725 0.746143 4.76032 0.933362 4.23928 1.24651C3.71825 1.55965 3.27749 1.99008 2.95207 2.50354C2.62666 3.01701 2.42557 3.59933 2.36481 4.20419C2.30406 4.80904 2.3853 5.41973 2.60209 5.98766C2.81888 6.55558 3.16523 7.06508 3.61357 7.4756C2.55233 7.93599 1.6299 8.66585 0.937793 9.59278C0.876172 9.67486 0.83132 9.76827 0.805799 9.86768C0.780277 9.96709 0.774586 10.0706 0.78905 10.1722C0.803514 10.2738 0.837849 10.3715 0.890096 10.4599C0.942343 10.5482 1.01148 10.6254 1.09355 10.687C1.17563 10.7486 1.26904 10.7935 1.36845 10.819C1.46786 10.8445 1.57132 10.8502 1.67293 10.8358C1.77454 10.8213 1.87231 10.787 1.96065 10.7347C2.04899 10.6825 2.12617 10.6133 2.18779 10.5313C2.65868 9.89831 3.2716 9.38477 3.97721 9.03196C4.68282 8.67916 5.4614 8.49695 6.25029 8.50001C6.45749 8.50001 6.65621 8.4177 6.80272 8.27119C6.94923 8.12468 7.03154 7.92596 7.03154 7.71876Z"
                                    fill="white" fill-opacity="0.7"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Alumni') }}</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('membership-package') }}"
                       class="d-flex align-items-center cg-10 {{ $activeMembershipPack ?? '' }}">
                        <div class="d-flex">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M20.4906 9.39822C20.4906 14.0906 16.6867 17.8945 11.9943 17.8945C7.30197 17.8945 3.49805 14.0906 3.49805 9.39822C3.49805 4.70585 7.30197 0.901924 11.9943 0.901924C16.6867 0.901924 20.4906 4.70585 20.4906 9.39822Z"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round"/>
                                <path
                                    d="M4.63477 13.5656L0.856444 20.1099L4.93902 19.016L6.03294 23.0985L9.3112 17.4204"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round"/>
                                <path d="M19.3652 13.5656L23.1436 20.1099L19.061 19.016L17.9671 23.0985L14.6888 17.4204"
                                      stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <path
                                    d="M16.9679 14.0017C16.6749 13.1815 16.0292 12.4568 15.1311 11.9399C14.2329 11.423 13.1324 11.1429 12.0003 11.1429C10.8682 11.1429 9.76768 11.423 8.86951 11.9399C7.97134 12.4568 7.32568 13.1815 7.03266 14.0017"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"/>
                                <circle cx="11.9972" cy="6" r="2.57143" stroke="white"
                                        stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"/>
                            </svg>
                        </div>
                        <span>{{ __('Membership') }}</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('chats.index') }}"
                       class="{{ $activeMessage ?? '' }} d-flex align-items-center cg-10">
                        <div class="d-flex">
                            <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M20.1305 6.01848C20.8327 7.06941 20.8327 8.53239 20.8327 11.4584C20.8327 14.3843 20.8327 15.8473 20.1305 16.8982C19.8265 17.3532 19.4358 17.7438 18.9809 18.0478C18.0628 18.6613 16.8303 18.7388 14.5827 18.7486V18.75L13.431 21.0533C13.0472 21.8211 11.9515 21.8211 11.5677 21.0533L10.416 18.75V18.7486C8.16841 18.7388 6.93588 18.6613 6.01781 18.0478C5.56285 17.7438 5.17222 17.3532 4.86823 16.8982C4.16602 15.8473 4.16602 14.3843 4.16602 11.4584C4.16602 8.53239 4.16602 7.06941 4.86823 6.01848C5.17222 5.56352 5.56285 5.17289 6.01781 4.8689C7.06874 4.16669 8.53172 4.16669 11.4577 4.16669H13.541C16.467 4.16669 17.93 4.16669 18.9809 4.8689C19.4358 5.17289 19.8265 5.56352 20.1305 6.01848Z"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round"/>
                                <path d="M9.375 9.375L15.625 9.375" stroke="white" stroke-opacity="0.7"
                                      stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M9.375 13.5417H12.5" stroke="white" stroke-opacity="0.7" stroke-width="1.5"
                                      stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span>{{ __('Messages') }}</span>
                    </a>
                </li>
                @endif
                <li>
                    <a href="{{ route('transaction.list') }}"
                       class="d-flex align-items-center cg-10 {{ $activeTransactionList ?? '' }}">
                        <div class="d-flex">
                            <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <rect x="3.31836" y="6.94522" width="18" height="12" rx="2" stroke="white"
                                      stroke-opacity="0.7" stroke-width="1.5"></rect>
                                <path d="M5.31836 9.94522H8.31836" stroke="white" stroke-opacity="0.7"
                                      stroke-width="1.5"
                                      stroke-linecap="round"></path>
                                <path d="M16.3184 15.9452H19.3184" stroke="white" stroke-opacity="0.7"
                                      stroke-width="1.5"
                                      stroke-linecap="round"></path>
                                <circle cx="12.3184" cy="12.9452" r="2" stroke="white" stroke-opacity="0.7"
                                        stroke-width="1.5"></circle>
                            </svg>
                        </div>
                        <span class="">{{ __('Transaction List') }}</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('profile') }}" class="{{ $activeProfile ?? '' }} d-flex align-items-center cg-10">
                        <div class="d-flex">
                            <svg width="24" height="25" viewBox="0 0 24 25" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M19.7274 21.3923C19.2716 20.1165 18.2672 18.9892 16.8701 18.1851C15.4729 17.381 13.7611 16.9452 12 16.9452C10.2389 16.9452 8.52706 17.381 7.12991 18.1851C5.73276 18.9892 4.72839 20.1165 4.27259 21.3923"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"/>
                                <circle cx="12" cy="8.94522" r="4" stroke="white"
                                        stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Profile') }}</span>
                    </a>
                </li>
                <li>
                    <a href="{{ route('settings') }}"
                       class="{{ $activeSettings ?? '' }} d-flex align-items-center cg-10">
                        <div class="d-flex">
                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M18.8074 6.62355L18.185 5.54346C17.6584 4.62954 16.4914 4.31426 15.5763 4.83866V4.83866C15.1406 5.09528 14.6208 5.16809 14.1314 5.04103C13.6421 4.91396 13.2233 4.59746 12.9676 4.16131C12.803 3.88409 12.7146 3.56833 12.7113 3.24598V3.24598C12.7261 2.72916 12.5311 2.22834 12.1708 1.85761C11.8104 1.48688 11.3153 1.2778 10.7982 1.27802H9.54423C9.0377 1.27801 8.55205 1.47985 8.19473 1.83888C7.83742 2.19791 7.63791 2.68453 7.64034 3.19106V3.19106C7.62533 4.23686 6.77321 5.07675 5.7273 5.07664C5.40494 5.07329 5.08919 4.98488 4.81197 4.82035V4.82035C3.89679 4.29595 2.72985 4.61123 2.20327 5.52516L1.53508 6.62355C1.00914 7.53633 1.32013 8.70255 2.23073 9.23225V9.23225C2.82263 9.57398 3.18726 10.2055 3.18726 10.889C3.18726 11.5725 2.82263 12.204 2.23073 12.5457V12.5457C1.32129 13.0719 1.00996 14.2353 1.53508 15.1453V15.1453L2.16666 16.2345C2.41338 16.6797 2.82734 17.0082 3.31693 17.1474C3.80652 17.2865 4.33137 17.2248 4.77535 16.976V16.976C5.21181 16.7213 5.73192 16.6515 6.22007 16.7821C6.70822 16.9128 7.12397 17.233 7.3749 17.6716C7.53943 17.9488 7.62784 18.2646 7.63119 18.5869V18.5869C7.63119 19.6435 8.48769 20.5 9.54423 20.5H10.7982C11.8512 20.5 12.7062 19.6491 12.7113 18.5961V18.5961C12.7088 18.088 12.9096 17.6 13.2689 17.2407C13.6282 16.8814 14.1162 16.6806 14.6243 16.6831C14.9459 16.6917 15.2604 16.7797 15.5397 16.9393V16.9393C16.4524 17.4653 17.6186 17.1543 18.1484 16.2437V16.2437L18.8074 15.1453C19.0625 14.7074 19.1325 14.1859 19.0019 13.6963C18.8714 13.2067 18.551 12.7893 18.1117 12.5366V12.5366C17.6725 12.2839 17.3521 11.8665 17.2215 11.3769C17.091 10.8872 17.161 10.3658 17.4161 9.9279C17.582 9.63827 17.8221 9.39814 18.1117 9.23225V9.23225C19.0169 8.70283 19.3271 7.54343 18.8074 6.63271V6.63271V6.62355Z"
                                      stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <circle cx="10.1752" cy="10.889" r="2.63616" stroke="white"
                                        stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Settings') }}</span>
                    </a>
                </li>
            @if (auth()->user()->role == USER_ROLE_ADMIN)
                @if(!isCentralDomain() || !isAddonInstalled('ALUSAAS'))
                <li class="sidebar-divider">
                    <p class="fs-9 fw-500 lh-20 text-white-32">{{ __('ADMIN MENU') }}</p>
                </li>
                <li>
                    <a href="#alumni-admin" data-bs-toggle="collapse" role="button"
                       aria-expanded="{{ isset($showAdminAlumni) ? 'true' : '' }}" aria-controls="membership-admin"
                       class="d-flex align-items-center cg-10 {{ isset($showAdminAlumni) ? 'active' : 'collapsed' }}">
                        <div class="d-flex">
                            <svg width="25" height="18" viewBox="0 0 25 18" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M23.9065 10.6875C23.8245 10.7491 23.7311 10.7939 23.6317 10.8193C23.5323 10.8448 23.4289 10.8504 23.3273 10.8359C23.2257 10.8214 23.128 10.787 23.0398 10.7348C22.9515 10.6825 22.8744 10.6133 22.8128 10.5313C22.3419 9.89831 21.729 9.38477 21.0234 9.03196C20.3178 8.67916 19.5392 8.49695 18.7503 8.50001C18.5967 8.5 18.4464 8.45469 18.3184 8.36975C18.1904 8.28481 18.0903 8.16402 18.0306 8.02247C17.99 7.92635 17.9691 7.82309 17.9691 7.71876C17.9691 7.61444 17.99 7.51117 18.0306 7.41505C18.0903 7.2735 18.1904 7.15271 18.3184 7.06777C18.4464 6.98283 18.5967 6.93753 18.7503 6.93751C19.1886 6.93747 19.6182 6.8145 19.9902 6.58257C20.3621 6.35064 20.6616 6.01904 20.8546 5.62544C21.0475 5.23184 21.1262 4.79202 21.0817 4.35593C21.0373 3.91984 20.8714 3.50497 20.6029 3.15843C20.3345 2.8119 19.9742 2.54759 19.5631 2.39554C19.152 2.24348 18.7064 2.20977 18.2771 2.29824C17.8478 2.3867 17.4518 2.5938 17.1343 2.896C16.8168 3.1982 16.5903 3.58339 16.4808 4.00782C16.4551 4.10721 16.4101 4.20058 16.3484 4.28258C16.2867 4.36459 16.2094 4.43364 16.121 4.48578C16.0326 4.53792 15.9347 4.57214 15.8331 4.58648C15.7315 4.60082 15.628 4.595 15.5286 4.56935C15.4292 4.5437 15.3359 4.49872 15.2539 4.43699C15.1718 4.37526 15.1028 4.29798 15.0507 4.20957C14.9985 4.12115 14.9643 4.02333 14.95 3.92169C14.9356 3.82006 14.9414 3.71659 14.9671 3.6172C15.1192 3.02864 15.4066 2.4837 15.8063 2.02575C16.2061 1.56779 16.7072 1.20946 17.2699 0.97926C17.8325 0.749062 18.4411 0.653353 19.0472 0.699748C19.6533 0.746143 20.2403 0.933362 20.7613 1.24651C21.2823 1.55965 21.7231 1.99008 22.0485 2.50354C22.3739 3.01701 22.575 3.59933 22.6358 4.20419C22.6965 4.80904 22.6153 5.41973 22.3985 5.98766C22.1817 6.55558 21.8354 7.06508 21.387 7.4756C22.4493 7.93555 23.3728 8.66545 24.0657 9.59278C24.1273 9.67507 24.172 9.76869 24.1973 9.86828C24.2226 9.96787 24.228 10.0715 24.2133 10.1732C24.1985 10.2749 24.1638 10.3726 24.1111 10.4609C24.0585 10.5492 23.989 10.6262 23.9065 10.6875ZM18.6448 16.7031C18.7014 16.7921 18.7393 16.8915 18.7564 16.9955C18.7735 17.0994 18.7694 17.2058 18.7443 17.3081C18.7193 17.4105 18.6738 17.5067 18.6105 17.591C18.5473 17.6753 18.4677 17.7459 18.3765 17.7986C18.2853 17.8514 18.1843 17.8851 18.0797 17.8978C17.9751 17.9105 17.869 17.9019 17.7678 17.8726C17.6666 17.8432 17.5724 17.7937 17.4909 17.727C17.4093 17.6603 17.3421 17.5777 17.2933 17.4844C16.8011 16.6511 16.1002 15.9604 15.2597 15.4807C14.4192 15.0009 13.4681 14.7486 12.5003 14.7486C11.5325 14.7486 10.5814 15.0009 9.74089 15.4807C8.90038 15.9604 8.19947 16.6511 7.70732 17.4844C7.65848 17.5777 7.59126 17.6603 7.50971 17.727C7.42815 17.7937 7.33394 17.8432 7.23274 17.8726C7.13155 17.9019 7.02546 17.9105 6.92087 17.8978C6.81627 17.8851 6.71532 17.8514 6.6241 17.7986C6.53288 17.7459 6.45326 17.6753 6.39005 17.591C6.32683 17.5067 6.28132 17.4105 6.25625 17.3081C6.23119 17.2058 6.22708 17.0994 6.24418 16.9955C6.26128 16.8915 6.29924 16.7921 6.35576 16.7031C7.11318 15.4017 8.26806 14.3776 9.65068 13.7813C8.87268 13.1856 8.30091 12.3611 8.01572 11.4237C7.73054 10.4862 7.74629 9.48301 8.06076 8.555C8.37522 7.62698 8.9726 6.82084 9.76892 6.24989C10.5652 5.67894 11.5204 5.37188 12.5003 5.37188C13.4801 5.37188 14.4354 5.67894 15.2317 6.24989C16.028 6.82084 16.6254 7.62698 16.9398 8.555C17.2543 9.48301 17.27 10.4862 16.9849 11.4237C16.6997 12.3611 16.1279 13.1856 15.3499 13.7813C16.7325 14.3776 17.8874 15.4017 18.6448 16.7031ZM12.5003 13.1875C13.1184 13.1875 13.7225 13.0042 14.2365 12.6609C14.7504 12.3175 15.1509 11.8294 15.3874 11.2584C15.6239 10.6874 15.6858 10.059 15.5652 9.45285C15.4447 8.84666 15.147 8.28984 14.71 7.8528C14.273 7.41576 13.7161 7.11814 13.11 6.99756C12.5038 6.87698 11.8754 6.93886 11.3044 7.17539C10.7334 7.41191 10.2453 7.81245 9.90195 8.32635C9.55857 8.84026 9.37529 9.44444 9.37529 10.0625C9.37529 10.8913 9.70453 11.6862 10.2906 12.2722C10.8766 12.8583 11.6715 13.1875 12.5003 13.1875ZM7.03154 7.71876C7.03154 7.51156 6.94923 7.31285 6.80272 7.16633C6.65621 7.01982 6.45749 6.93751 6.25029 6.93751C5.81194 6.93747 5.38239 6.8145 5.01042 6.58257C4.63845 6.35064 4.33898 6.01904 4.14603 5.62544C3.95307 5.23184 3.87437 4.79202 3.91885 4.35593C3.96333 3.91984 4.12921 3.50497 4.39766 3.15843C4.66611 2.8119 5.02637 2.54759 5.4375 2.39554C5.84863 2.24348 6.29417 2.20977 6.7235 2.29824C7.15283 2.3867 7.54875 2.5938 7.86628 2.896C8.18382 3.1982 8.41024 3.58339 8.51982 4.00782C8.57162 4.20855 8.70104 4.38048 8.8796 4.48578C9.05817 4.59109 9.27125 4.62115 9.47197 4.56935C9.6727 4.51755 9.84462 4.38813 9.94993 4.20957C10.0552 4.03101 10.0853 3.81792 10.0335 3.6172C9.88139 3.02864 9.59402 2.4837 9.19425 2.02575C8.79448 1.56779 8.29334 1.20946 7.73072 0.97926C7.16809 0.749062 6.5595 0.653353 5.95338 0.699748C5.34725 0.746143 4.76032 0.933362 4.23928 1.24651C3.71825 1.55965 3.27749 1.99008 2.95207 2.50354C2.62666 3.01701 2.42557 3.59933 2.36481 4.20419C2.30406 4.80904 2.3853 5.41973 2.60209 5.98766C2.81888 6.55558 3.16523 7.06508 3.61357 7.4756C2.55233 7.93599 1.6299 8.66585 0.937793 9.59278C0.876172 9.67486 0.83132 9.76827 0.805799 9.86768C0.780277 9.96709 0.774586 10.0706 0.78905 10.1722C0.803514 10.2738 0.837849 10.3715 0.890096 10.4599C0.942343 10.5482 1.01148 10.6254 1.09355 10.687C1.17563 10.7486 1.26904 10.7935 1.36845 10.819C1.46786 10.8445 1.57132 10.8502 1.67293 10.8358C1.77454 10.8213 1.87231 10.787 1.96065 10.7347C2.04899 10.6825 2.12617 10.6133 2.18779 10.5313C2.65868 9.89831 3.2716 9.38477 3.97721 9.03196C4.68282 8.67916 5.4614 8.49695 6.25029 8.50001C6.45749 8.50001 6.65621 8.4177 6.80272 8.27119C6.94923 8.12468 7.03154 7.92596 7.03154 7.71876Z"
                                    fill="white" fill-opacity="0.7"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Manage Alumni') }}</span>
                    </a>
                    <div class="collapse {{ $showAdminAlumni ?? '' }}" id="alumni-admin"
                         data-bs-parent="#sidebarMenu">
                        <ul class="zSidebar-submenu">
                            <li><a class="{{ $activeAlumniApprovedList ?? '' }}"
                                   href="{{ route('admin.alumni.list-search-with-filter') }}">{{ __('All List') }}</a>
                            </li>
                            <li><a class="{{ $activeAlumniPendingList ?? '' }}"
                                   href="{{ route('admin.alumni.list-pending-alumni-with-filter') }}">{{ __('Pending List') }}</a>
                            </li>
                        </ul>
                    </div>
                </li>
                <li>
                    <a href="#membership-admin" data-bs-toggle="collapse" role="button"
                       aria-expanded="{{ isset($showMembership) ? 'true' : '' }}" aria-controls="membership-admin"
                       class="d-flex align-items-center cg-10 {{ isset($showMembership) ? 'active' : 'collapsed' }}">
                        <div class="d-flex">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M20.4906 9.39822C20.4906 14.0906 16.6867 17.8945 11.9943 17.8945C7.30197 17.8945 3.49805 14.0906 3.49805 9.39822C3.49805 4.70585 7.30197 0.901924 11.9943 0.901924C16.6867 0.901924 20.4906 4.70585 20.4906 9.39822Z"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round"/>
                                <path
                                    d="M4.63477 13.5656L0.856444 20.1099L4.93902 19.016L6.03294 23.0985L9.3112 17.4204"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round"/>
                                <path
                                    d="M19.3652 13.5656L23.1436 20.1099L19.061 19.016L17.9671 23.0985L14.6888 17.4204"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round"/>
                                <path
                                    d="M16.9679 14.0017C16.6749 13.1815 16.0292 12.4568 15.1311 11.9399C14.2329 11.423 13.1324 11.1429 12.0003 11.1429C10.8682 11.1429 9.76768 11.423 8.86951 11.9399C7.97134 12.4568 7.32568 13.1815 7.03266 14.0017"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"/>
                                <circle cx="11.9972" cy="6" r="2.57143" stroke="white"
                                        stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Manage Membership') }}</span>
                    </a>
                    <div class="collapse {{ $showMembership ?? '' }}" id="membership-admin"
                         data-bs-parent="#sidebarMenu">
                        <ul class="zSidebar-submenu">
                            <li>
                                <a class="{{ $activeMembershipCreate ?? '' }}"
                                   href="{{ route('admin.membership.index') }}">{{ __('Membership Plan') }}</a>
                            </li>
                            <li><a class="{{ $activeMemberList ?? '' }}"
                                   href="{{ route('admin.membership.list') }}">{{ __('Member List') }}</a></li>
                        </ul>
                    </div>
                </li>
                <li>
                    <a href="#manage-notice-menu" data-bs-toggle="collapse" role="button"
                       aria-expanded="{{ isset($showManageNotice) ? 'true' : 'false' }}"
                       aria-controls="manage-notice-menu"
                       class="d-flex align-items-center cg-10 {{ isset($showManageNotice) ? 'active' : 'collapsed' }}">
                        <div class="d-flex">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <circle cx="10" cy="10" r="9.25" stroke="white"
                                        stroke-opacity="0.7" stroke-width="1.5"/>
                                <path
                                    d="M9.18262 11.7393L9.08008 4.81445H10.7207L10.6113 11.7393H9.18262ZM9.90039 15.0957C9.61328 15.0957 9.37174 15.0023 9.17578 14.8154C8.98438 14.624 8.88867 14.3893 8.88867 14.1113C8.88867 13.8288 8.98438 13.5941 9.17578 13.4072C9.37174 13.2158 9.61328 13.1201 9.90039 13.1201C10.1829 13.1201 10.4199 13.2158 10.6113 13.4072C10.8073 13.5941 10.9053 13.8288 10.9053 14.1113C10.9053 14.3893 10.8073 14.624 10.6113 14.8154C10.4199 15.0023 10.1829 15.0957 9.90039 15.0957Z"
                                    fill="white" fill-opacity="0.7"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Manage Notice') }}</span>
                    </a>

                    <div class="collapse {{ $showManageNotice ?? '' }}" id="manage-notice-menu"
                         data-bs-parent="#sidebarMenu">
                        <ul class="zSidebar-submenu">
                            <li><a class="{{ $activeNoticeCategory ?? '' }}"
                                   href="{{ route('admin.notices.categories.index') }}">{{ 'Category' }}</a></li>
                            <li><a class="{{ $activeManageNotice ?? '' }}"
                                   href="{{ route('admin.notices.index') }}">{{ 'Notice' }}</a></li>
                        </ul>
                    </div>
                </li>
                <li>
                    <a href="#manage-news-menu" data-bs-toggle="collapse" role="button"
                       aria-expanded="{{ isset($showManageNews) ? 'true' : 'false' }}"
                       aria-controls="manage-news-menu"
                       class="d-flex align-items-center cg-10 {{ isset($showManageNews) ? 'active' : 'collapsed' }}">
                        <div class="d-flex">
                            <svg width="20" height="18" viewBox="0 0 20 18" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M1 1V15C1 15.5304 1.21071 16.0391 1.58579 16.4142C1.96086 16.7893 2.46957 17 3 17H17C17.5304 17 18.0391 16.7893 18.4142 16.4142C18.7893 16.0391 19 15.5304 19 15V5H15"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round"/>
                                <path
                                    d="M1 1H15V15C15 15.5304 15.2107 16.0391 15.5858 16.4142C15.9609 16.7893 16.4696 17 17 17M11 5H5M11 9H7"
                                    stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Manage News') }}</span>
                    </a>
                    <div class="collapse {{ $showManageNews ?? '' }}" id="manage-news-menu"
                         data-bs-parent="#sidebarMenu">
                        <ul class="zSidebar-submenu">
                            <li><a class="{{ $activeNewsTag ?? '' }}"
                                   href="{{ route('admin.news.tags.index') }}">{{ __('Tag') }}</a></li>
                            <li><a class="{{ $activeNewsCategory ?? '' }}"
                                   href="{{ route('admin.news.categories.index') }}">{{ __('Category') }}</a></li>
                            <li><a class="{{ $activeManageNews ?? '' }}"
                                   href="{{ route('admin.news.index') }}">{{ __('News') }}</a></li>
                        </ul>
                    </div>
                </li>
                <li>
                    <a href="#manage-transaction-menu" data-bs-toggle="collapse" role="button"
                       aria-expanded="{{ isset($showTransactionNotice) ? 'true' : 'false' }}"
                       aria-controls="manage-transaction-menu"
                       class="d-flex align-items-center cg-10 {{ isset($showTransactionNotice) ? 'active' : 'collapsed' }}">
                        <div class="d-flex">
                            <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <rect x="3.31836" y="6.94522" width="18" height="12" rx="2" stroke="white"
                                      stroke-opacity="0.7" stroke-width="1.5"></rect>
                                <path d="M5.31836 9.94522H8.31836" stroke="white" stroke-opacity="0.7"
                                      stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M16.3184 15.9452H19.3184" stroke="white" stroke-opacity="0.7"
                                      stroke-width="1.5" stroke-linecap="round"></path>
                                <circle cx="12.3184" cy="12.9452" r="2" stroke="white" stroke-opacity="0.7"
                                        stroke-width="1.5"></circle>
                            </svg>
                        </div>
                        <span class="">{{ __('Manage Transaction') }}</span>
                    </a>

                    <div class="collapse {{ $showTransactionNotice ?? '' }}" id="manage-transaction-menu"
                         data-bs-parent="#sidebarMenu">
                        <ul class="zSidebar-submenu">
                            <li><a class="{{ $activePaymentNotice ?? '' }}"
                                   href="{{route('admin.transactions.pending.list')}}">{{ 'Pending Transaction' }}</a>
                            </li>
                            <li><a class="{{ $activeTransactionNotice ?? '' }}"
                                   href="{{route('admin.transactions.all.list')}}">{{ 'All Transaction' }}</a></li>
                            <li><a class="{{ $activeEventNotice ?? '' }}"
                                   href="{{route('admin.transactions.event.list')}}">{{ 'Event Transaction' }}</a></li>
                            <li><a class="{{ $activeMembershipNotice ?? '' }}"
                                   href="{{route('admin.transactions.membership.list')}}">{{ 'Membership Transaction' }}</a>
                            </li>
                            @if(isAddonInstalled('ALUSAAS'))
                                <li><a class="{{ $activeAdminTransaction ?? '' }}"
                                       href="{{route('admin.subscription.transaction.list')}}">{{ 'Subscription Transaction' }}</a>
                                </li>
                            @endif
                        </ul>
                    </div>
                </li>
                <li>
                    <a href="{{ route('admin.setting.website-settings.index') }}"
                       class="{{ $activeManageWebsiteSetting ?? '' }} d-flex align-items-center cg-10">
                        <div class="d-flex">
                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M18.8074 6.62355L18.185 5.54346C17.6584 4.62954 16.4914 4.31426 15.5763 4.83866V4.83866C15.1406 5.09528 14.6208 5.16809 14.1314 5.04103C13.6421 4.91396 13.2233 4.59746 12.9676 4.16131C12.803 3.88409 12.7146 3.56833 12.7113 3.24598V3.24598C12.7261 2.72916 12.5311 2.22834 12.1708 1.85761C11.8104 1.48688 11.3153 1.2778 10.7982 1.27802H9.54423C9.0377 1.27801 8.55205 1.47985 8.19473 1.83888C7.83742 2.19791 7.63791 2.68453 7.64034 3.19106V3.19106C7.62533 4.23686 6.77321 5.07675 5.7273 5.07664C5.40494 5.07329 5.08919 4.98488 4.81197 4.82035V4.82035C3.89679 4.29595 2.72985 4.61123 2.20327 5.52516L1.53508 6.62355C1.00914 7.53633 1.32013 8.70255 2.23073 9.23225V9.23225C2.82263 9.57398 3.18726 10.2055 3.18726 10.889C3.18726 11.5725 2.82263 12.204 2.23073 12.5457V12.5457C1.32129 13.0719 1.00996 14.2353 1.53508 15.1453V15.1453L2.16666 16.2345C2.41338 16.6797 2.82734 17.0082 3.31693 17.1474C3.80652 17.2865 4.33137 17.2248 4.77535 16.976V16.976C5.21181 16.7213 5.73192 16.6515 6.22007 16.7821C6.70822 16.9128 7.12397 17.233 7.3749 17.6716C7.53943 17.9488 7.62784 18.2646 7.63119 18.5869V18.5869C7.63119 19.6435 8.48769 20.5 9.54423 20.5H10.7982C11.8512 20.5 12.7062 19.6491 12.7113 18.5961V18.5961C12.7088 18.088 12.9096 17.6 13.2689 17.2407C13.6282 16.8814 14.1162 16.6806 14.6243 16.6831C14.9459 16.6917 15.2604 16.7797 15.5397 16.9393V16.9393C16.4524 17.4653 17.6186 17.1543 18.1484 16.2437V16.2437L18.8074 15.1453C19.0625 14.7074 19.1325 14.1859 19.0019 13.6963C18.8714 13.2067 18.551 12.7893 18.1117 12.5366V12.5366C17.6725 12.2839 17.3521 11.8665 17.2215 11.3769C17.091 10.8872 17.161 10.3658 17.4161 9.9279C17.582 9.63827 17.8221 9.39814 18.1117 9.23225V9.23225C19.0169 8.70283 19.3271 7.54343 18.8074 6.63271V6.63271V6.62355Z"
                                      stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                                <circle cx="10.1752" cy="10.889" r="2.63616" stroke="white"
                                        stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Website Settings') }}</span>
                    </a>
                </li>
                <li>
                    <a href="#manage-application-menu" data-bs-toggle="collapse" role="button"
                       aria-expanded="{{ isset($showManageApplicationSetting) ? 'true' : '' }}"
                       aria-controls="manage-application-menu"
                       class="d-flex align-items-center cg-10 {{ isset($showManageApplicationSetting) ? 'active' : 'collapsed' }}">
                        <div class="d-flex">
                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path d="M18.5 6L10 1L1.5 6V16L10 21L18.5 16V6Z" stroke="white" stroke-opacity="0.7"
                                      stroke-width="1.5" stroke-linejoin="round"/>
                                <path d="M6 8.49902L9.9965 11L13.9975 8.49902M10 11V15.5" stroke="white"
                                      stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="">{{ __('Application Settings') }}</span>
                    </a>
                    <div class="collapse {{ $showManageApplicationSetting ?? '' }}" id="manage-application-menu"
                         data-bs-parent="#sidebarMenu">
                        <ul class="zSidebar-submenu">
                            <li><a class="{{ $activeApplicationSetting ?? '' }}"
                                   href="{{ route('admin.setting.application-settings') }}">{{ __('General Settings') }}</a>
                            </li>
                            <li><a class="{{ $activeConfigurationSetting ?? '' }}"
                                   href="{{ route('admin.setting.configuration-settings') }}">{{ __('Configurations
                                                                        								Settings') }}</a>
                            </li>
                            <li><a class="{{ $activeCurrenciesSetting ?? '' }}"
                                   href="{{ route('admin.setting.currencies.index') }}">{{ __('Currency Settings') }}</a>
                            </li>
                            <li><a class="{{ $activeGatewaySetting ?? '' }}"
                                   href="{{ route('admin.setting.gateway.index') }}">{{ __('Payment Gateways') }}</a>
                            </li>
                            @if(!isAddonInstalled('ALUSAAS'))
                            <li><a class="{{ $activeLanguagesSetting ?? '' }}"
                                   href="{{ route('admin.setting.languages.index') }}">{{ __('Language Settings') }}</a>
                            </li>
                            @endif
                            <li><a class="{{ $activeBatchesSetting ?? '' }}"
                                   href="{{ route('admin.setting.batches.index') }}">{{ __('Batch Setting') }}</a>
                            </li>
                            <li><a class="{{ $activeDepartmentsSetting ?? '' }}"
                                   href="{{ route('admin.setting.departments.index') }}">{{ __('Department Setting') }}</a>
                            </li>
                            <li><a class="{{ $activePassingSetting ?? '' }}"
                                   href="{{ route('admin.setting.passing_years.index') }}">{{ __('Passing Year') }}</a>
                            </li>
                            <li><a class="{{ $activeEmailSetting ?? '' }}"
                                   href="{{ route('admin.setting.email-template') }}">{{ __('Email Template') }}</a>
                            </li>
                        </ul>
                    </div>
                </li>
                @endif
                @if(isAddonInstalled('ALUSAAS'))
                    <li>
                        <a href="{{ route('admin.subscription.index') }}"
                           class="{{ $activeSubscription ?? '' }} d-flex align-items-center cg-10">
                            <div class="d-flex">
                                <svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 23 23" fill="none">
                                    <path d="M12.3398 0.61335L20.2461 5.17693C20.7646 5.47689 21.0846 6.02985 21.0846 6.62881V15.7569C21.0847 16.0514 21.0073 16.3407 20.8601 16.5957C20.7129 16.8508 20.5011 17.0625 20.2461 17.2098L12.3398 21.7733C12.085 21.9207 11.7957 21.9983 11.5013 21.9983C11.2069 21.9983 10.9176 21.9207 10.6628 21.7733L2.75651 17.2088C2.50164 17.0617 2.28998 16.85 2.14279 16.5952C1.9956 16.3403 1.91806 16.0512 1.91797 15.7569V6.62881C1.91797 6.02985 2.23805 5.47689 2.75651 5.17693L10.6628 0.61335C10.9176 0.465967 11.2069 0.388367 11.5013 0.388367C11.7957 0.388367 12.085 0.465967 12.3398 0.61335ZM11.3815 1.85727L4.07422 6.07585L11.5013 10.3634L18.9284 6.07585L11.6211 1.85727C11.5847 1.83605 11.5434 1.82487 11.5013 1.82487C11.4592 1.82487 11.4179 1.83605 11.3815 1.85727ZM12.2201 20.1835L19.5273 15.9649C19.5637 15.9439 19.5939 15.9137 19.6149 15.8774C19.6359 15.8411 19.6471 15.7999 19.6471 15.7579V7.32072L12.2201 11.6083V20.1835ZM3.35547 7.32168V15.7579C3.35547 15.8441 3.40147 15.9227 3.47526 15.9649L10.7826 20.1835V11.6093L3.35547 7.32168Z" fill="white" fill-opacity="0.7"/>
                                </svg>
                            </div>
                            <span class="">{{ __('My Subscriptions') }}</span>
                        </a>
                    </li>
                    @if(getPackageLimit(PACKAGE_RULE_CUSTOM_DOMAIN))
                        <li>
                            <a href="{{ route('admin.custom_domain.index') }}"
                               class="{{ $activeCustomDomainRequest ?? '' }} d-flex align-items-center cg-10">
                                <div class="d-flex">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M7.84308 3.80211C9.8718 2.6007 10.8862 2 12 2C13.1138 2 14.1282 2.6007 16.1569 3.80211L16.8431 4.20846C18.8718 5.40987 19.8862 6.01057 20.4431 7C21 7.98943 21 9.19084 21 11.5937V12.4063C21 14.8092 21 16.0106 20.4431 17C19.8862 17.9894 18.8718 18.5901 16.8431 19.7915L16.1569 20.1979C14.1282 21.3993 13.1138 22 12 22C10.8862 22 9.8718 21.3993 7.84308 20.1979L7.15692 19.7915C5.1282 18.5901 4.11384 17.9894 3.55692 17C3 16.0106 3 14.8092 3 12.4063V11.5937C3 9.19084 3 7.98943 3.55692 7C4.11384 6.01057 5.1282 5.40987 7.15692 4.20846L7.84308 3.80211Z"
                                            stroke="white" stroke-opacity="0.7" stroke-width="1.5" stroke-linecap="round" />
                                        <circle cx="12" cy="12" r="3" stroke="white" stroke-width="1.5"
                                                stroke-opacity="0.7" />
                                    </svg>
                                </div>
                                <span class="">{{ __('Domain Setting') }}</span>
                            </a>
                        </li>
                    @endif
                @endif
                @if(!isAddonInstalled('ALUSAAS'))
                    <li>
                        <a href="{{ route('admin.version-update') }}"
                           class="{{ $activeVersionUpdate ?? '' }} d-flex align-items-center cg-10">
                            <div class="d-flex">
                                <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26"
                                     fill="none">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M8.27884 4.92549C10.0763 3.88705 12.1654 3.46843 14.2242 3.73408C16.283 3.99973 18.1974 4.93491 19.6723 6.39559C21.1474 7.8563 22.1012 9.76146 22.387 11.8176C22.4661 12.3865 22.069 12.9118 21.5 12.9908C20.9311 13.0699 20.4058 12.6728 20.3268 12.1039C20.1038 10.4996 19.3597 9.01321 18.2088 7.87359C17.0581 6.73393 15.5644 6.00424 13.958 5.79697C12.3516 5.58971 10.7218 5.91633 9.31934 6.72653C8.39658 7.25961 7.60597 7.98262 6.99568 8.8407H8.87688C9.45125 8.8407 9.91688 9.30633 9.91688 9.8807C9.91688 10.4551 9.45125 10.9207 8.87688 10.9207H5.26014C5.24439 10.921 5.2286 10.921 5.21279 10.9207H4.71688C4.1425 10.9207 3.67688 10.4551 3.67688 9.8807V5.7207C3.67688 5.14633 4.1425 4.6807 4.71688 4.6807C5.29126 4.6807 5.75688 5.14633 5.75688 5.7207V7.04449C6.46258 6.20169 7.31439 5.48266 8.27884 4.92549ZM4.57373 13.0107C5.14264 12.9316 5.66792 13.3287 5.74698 13.8976C5.96993 15.5018 6.71412 16.9882 7.86498 18.1279C9.01582 19.2676 10.5094 19.9972 12.1157 20.2045C13.722 20.4118 15.352 20.0851 16.7545 19.2749C17.6772 18.7418 18.4679 18.0188 19.0782 17.1607H17.1969C16.6225 17.1607 16.1569 16.6951 16.1569 16.1207C16.1569 15.5463 16.6225 15.0807 17.1969 15.0807H20.8136C20.8294 15.0804 20.8451 15.0804 20.861 15.0807H21.3569C21.9313 15.0807 22.3969 15.5463 22.3969 16.1207V20.2807C22.3969 20.8551 21.9313 21.3207 21.3569 21.3207C20.7825 21.3207 20.3169 20.8551 20.3169 20.2807V18.957C19.6112 19.7998 18.7594 20.5189 17.7949 21.076C15.9975 22.1144 13.9083 22.533 11.8495 22.2673C9.79073 22.0017 7.87638 21.0665 6.40137 19.6059C4.92637 18.1451 3.97252 16.24 3.68678 14.1839C3.60772 13.6151 4.00482 13.0897 4.57373 13.0107Z"
                                          fill="white" fill-opacity="0.7"/>
                                </svg>
                            </div>
                            <span class="">{{ __('Version Update') }}</span>
                        </a>
                    </li>
                @endif
            @endif
        </ul>
        <ul>
            @if(!isAddonInstalled('ALUSAAS'))
            <li class="d-inline-flex align-items-center cg-15 pt-17 px-25">
                <span class="align-items-center cg-10 has-subMenu-arrow">
                    {{ __('Version') }} : {{ getOption('current_version', 'v1.0') }}
                </span>
            </li>
            @endif
            <a href="{{ route('logout') }}"
               onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
               class="d-inline-flex align-items-center cg-15 pt-17 pb-30 px-25">
                <img src="{{ asset('assets/images/icon/logout.svg') }}" alt=""/>
                <p class="fs-14 fw-500 lh-16 text-white-70">{{ __('Logout') }}</p>
            </a>
            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                @csrf
            </form>
        </ul>
    </div>
</div>
