<?php //bcb85f097ba5e9899733cdafbf69411e
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphTo;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_Alumni_C;
    use LaravelIdea\Helper\App\Models\_IH_Alumni_QB;
    use LaravelIdea\Helper\App\Models\_IH_Bank_C;
    use LaravelIdea\Helper\App\Models\_IH_Bank_QB;
    use LaravelIdea\Helper\App\Models\_IH_Batch_C;
    use LaravelIdea\Helper\App\Models\_IH_Batch_QB;
    use LaravelIdea\Helper\App\Models\_IH_ChatMedia_C;
    use LaravelIdea\Helper\App\Models\_IH_ChatMedia_QB;
    use LaravelIdea\Helper\App\Models\_IH_Chat_C;
    use LaravelIdea\Helper\App\Models\_IH_Chat_QB;
    use LaravelIdea\Helper\App\Models\_IH_Currency_C;
    use LaravelIdea\Helper\App\Models\_IH_Currency_QB;
    use LaravelIdea\Helper\App\Models\_IH_DatabaseBackupSetting_C;
    use LaravelIdea\Helper\App\Models\_IH_DatabaseBackupSetting_QB;
    use LaravelIdea\Helper\App\Models\_IH_DatabaseBackup_C;
    use LaravelIdea\Helper\App\Models\_IH_DatabaseBackup_QB;
    use LaravelIdea\Helper\App\Models\_IH_Department_C;
    use LaravelIdea\Helper\App\Models\_IH_Department_QB;
    use LaravelIdea\Helper\App\Models\_IH_EmailTemplate_C;
    use LaravelIdea\Helper\App\Models\_IH_EmailTemplate_QB;
    use LaravelIdea\Helper\App\Models\_IH_EventCategory_C;
    use LaravelIdea\Helper\App\Models\_IH_EventCategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_EventTicket_C;
    use LaravelIdea\Helper\App\Models\_IH_EventTicket_QB;
    use LaravelIdea\Helper\App\Models\_IH_Event_C;
    use LaravelIdea\Helper\App\Models\_IH_Event_QB;
    use LaravelIdea\Helper\App\Models\_IH_FileManager_C;
    use LaravelIdea\Helper\App\Models\_IH_FileManager_QB;
    use LaravelIdea\Helper\App\Models\_IH_GatewayCurrency_C;
    use LaravelIdea\Helper\App\Models\_IH_GatewayCurrency_QB;
    use LaravelIdea\Helper\App\Models\_IH_Gateway_C;
    use LaravelIdea\Helper\App\Models\_IH_Gateway_QB;
    use LaravelIdea\Helper\App\Models\_IH_JobPost_C;
    use LaravelIdea\Helper\App\Models\_IH_JobPost_QB;
    use LaravelIdea\Helper\App\Models\_IH_Language_C;
    use LaravelIdea\Helper\App\Models\_IH_Language_QB;
    use LaravelIdea\Helper\App\Models\_IH_Membership_C;
    use LaravelIdea\Helper\App\Models\_IH_Membership_QB;
    use LaravelIdea\Helper\App\Models\_IH_Meta_C;
    use LaravelIdea\Helper\App\Models\_IH_Meta_QB;
    use LaravelIdea\Helper\App\Models\_IH_NewsCategory_C;
    use LaravelIdea\Helper\App\Models\_IH_NewsCategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_NewsTag_C;
    use LaravelIdea\Helper\App\Models\_IH_NewsTag_QB;
    use LaravelIdea\Helper\App\Models\_IH_News_C;
    use LaravelIdea\Helper\App\Models\_IH_News_QB;
    use LaravelIdea\Helper\App\Models\_IH_NoticeCategory_C;
    use LaravelIdea\Helper\App\Models\_IH_NoticeCategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_Notice_C;
    use LaravelIdea\Helper\App\Models\_IH_Notice_QB;
    use LaravelIdea\Helper\App\Models\_IH_NotificationSeen_C;
    use LaravelIdea\Helper\App\Models\_IH_NotificationSeen_QB;
    use LaravelIdea\Helper\App\Models\_IH_Notification_C;
    use LaravelIdea\Helper\App\Models\_IH_Notification_QB;
    use LaravelIdea\Helper\App\Models\_IH_PassingYear_C;
    use LaravelIdea\Helper\App\Models\_IH_PassingYear_QB;
    use LaravelIdea\Helper\App\Models\_IH_Payment_C;
    use LaravelIdea\Helper\App\Models\_IH_Payment_QB;
    use LaravelIdea\Helper\App\Models\_IH_PostComment_C;
    use LaravelIdea\Helper\App\Models\_IH_PostComment_QB;
    use LaravelIdea\Helper\App\Models\_IH_PostMedia_C;
    use LaravelIdea\Helper\App\Models\_IH_PostMedia_QB;
    use LaravelIdea\Helper\App\Models\_IH_Post_C;
    use LaravelIdea\Helper\App\Models\_IH_Post_QB;
    use LaravelIdea\Helper\App\Models\_IH_Setting_C;
    use LaravelIdea\Helper\App\Models\_IH_Setting_QB;
    use LaravelIdea\Helper\App\Models\_IH_Transaction_C;
    use LaravelIdea\Helper\App\Models\_IH_Transaction_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserInstitution_C;
    use LaravelIdea\Helper\App\Models\_IH_UserInstitution_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserMembershipPlan_C;
    use LaravelIdea\Helper\App\Models\_IH_UserMembershipPlan_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    use LaravelIdea\Helper\Rappasoft\LaravelAuthenticationLog\Models\_IH_AuthenticationLog_C;
    use LaravelIdea\Helper\Rappasoft\LaravelAuthenticationLog\Models\_IH_AuthenticationLog_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use Rappasoft\LaravelAuthenticationLog\Models\AuthenticationLog;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;

    /**
     * @property int $id
     * @property int $user_id
     * @property int $batch_id
     * @property int $department_id
     * @property int $passing_year_id
     * @property string $id_number
     * @property string $company
     * @property string $company_designation
     * @property string $company_address
     * @property string|null $file
     * @property string|null $blood_group
     * @property Carbon|null $date_of_birth
     * @property string|null $gender
     * @property string|null $about_me
     * @property string|null $linkedin_url
     * @property string|null $facebook_url
     * @property string|null $twitter_url
     * @property string|null $instagram_url
     * @property string|null $city
     * @property string|null $state
     * @property string|null $zip
     * @property string|null $country
     * @property string|null $address
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Transaction_C|Transaction[] $transactions
     * @property-read int $transactions_count
     * @method HasMany|_IH_Transaction_QB transactions()
     * @method static _IH_Alumni_QB onWriteConnection()
     * @method _IH_Alumni_QB newQuery()
     * @method static _IH_Alumni_QB on(null|string $connection = null)
     * @method static _IH_Alumni_QB query()
     * @method static _IH_Alumni_QB with(array|string $relations)
     * @method _IH_Alumni_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Alumni_C|Alumni[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|batch_id,\App\Models\Batch,id|department_id,\App\Models\Department,id|passing_year_id,\App\Models\PassingYear,id
     * @mixin _IH_Alumni_QB
     */
    class Alumni extends Model {}

    /**
     * @property int $id
     * @property int $gateway_id
     * @property string $name
     * @property string $details
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @method static _IH_Bank_QB onWriteConnection()
     * @method _IH_Bank_QB newQuery()
     * @method static _IH_Bank_QB on(null|string $connection = null)
     * @method static _IH_Bank_QB query()
     * @method static _IH_Bank_QB with(array|string $relations)
     * @method _IH_Bank_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Bank_C|Bank[] all()
     * @ownLinks gateway_id,\App\Models\Gateway,id
     * @foreignLinks id,\App\Models\Payment,bank_id
     * @mixin _IH_Bank_QB
     */
    class Bank extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Alumni_C|Alumni[] $alumni
     * @property-read int $alumni_count
     * @method HasMany|_IH_Alumni_QB alumni()
     * @method static _IH_Batch_QB onWriteConnection()
     * @method _IH_Batch_QB newQuery()
     * @method static _IH_Batch_QB on(null|string $connection = null)
     * @method static _IH_Batch_QB query()
     * @method static _IH_Batch_QB with(array|string $relations)
     * @method _IH_Batch_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Batch_C|Batch[] all()
     * @foreignLinks id,\App\Models\Alumni,batch_id
     * @mixin _IH_Batch_QB
     */
    class Batch extends Model {}

    /**
     * @property int $id
     * @property int $sender_id
     * @property int $receiver_id
     * @property string|null $message
     * @property int $is_seen
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_ChatMedia_C|ChatMedia[] $media
     * @property-read int $media_count
     * @method HasMany|_IH_ChatMedia_QB media()
     * @property User $receiver
     * @method BelongsTo|_IH_User_QB receiver()
     * @property User $sender
     * @method BelongsTo|_IH_User_QB sender()
     * @method static _IH_Chat_QB onWriteConnection()
     * @method _IH_Chat_QB newQuery()
     * @method static _IH_Chat_QB on(null|string $connection = null)
     * @method static _IH_Chat_QB query()
     * @method static _IH_Chat_QB with(array|string $relations)
     * @method _IH_Chat_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Chat_C|Chat[] all()
     * @foreignLinks id,\App\Models\ChatMedia,chat_id
     * @mixin _IH_Chat_QB
     */
    class Chat extends Model {}

    /**
     * @property int $id
     * @property int $chat_id
     * @property int $file
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Chat $chat
     * @method BelongsTo|_IH_Chat_QB chat()
     * @property FileManager $file_manager
     * @method BelongsTo|_IH_FileManager_QB file_manager()
     * @method static _IH_ChatMedia_QB onWriteConnection()
     * @method _IH_ChatMedia_QB newQuery()
     * @method static _IH_ChatMedia_QB on(null|string $connection = null)
     * @method static _IH_ChatMedia_QB query()
     * @method static _IH_ChatMedia_QB with(array|string $relations)
     * @method _IH_ChatMedia_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ChatMedia_C|ChatMedia[] all()
     * @ownLinks chat_id,\App\Models\Chat,id
     * @mixin _IH_ChatMedia_QB
     */
    class ChatMedia extends Model {}

    /**
     * @property int $id
     * @property string $currency_code
     * @property string $symbol
     * @property string $currency_placement
     * @property int|null $current_currency
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Currency_QB onWriteConnection()
     * @method _IH_Currency_QB newQuery()
     * @method static _IH_Currency_QB on(null|string $connection = null)
     * @method static _IH_Currency_QB query()
     * @method static _IH_Currency_QB with(array|string $relations)
     * @method _IH_Currency_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Currency_C|Currency[] all()
     * @mixin _IH_Currency_QB
     */
    class Currency extends Model {}

    /**
     * @property int $id
     * @property string|null $filename
     * @property string|null $size
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DatabaseBackup_QB onWriteConnection()
     * @method _IH_DatabaseBackup_QB newQuery()
     * @method static _IH_DatabaseBackup_QB on(null|string $connection = null)
     * @method static _IH_DatabaseBackup_QB query()
     * @method static _IH_DatabaseBackup_QB with(array|string $relations)
     * @method _IH_DatabaseBackup_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DatabaseBackup_C|DatabaseBackup[] all()
     * @mixin _IH_DatabaseBackup_QB
     */
    class DatabaseBackup extends Model {}

    /**
     * @property int $id
     * @property string $status
     * @property Carbon $hour_of_day
     * @property string|null $backup_after_days
     * @property string|null $delete_backup_after_days
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DatabaseBackupSetting_QB onWriteConnection()
     * @method _IH_DatabaseBackupSetting_QB newQuery()
     * @method static _IH_DatabaseBackupSetting_QB on(null|string $connection = null)
     * @method static _IH_DatabaseBackupSetting_QB query()
     * @method static _IH_DatabaseBackupSetting_QB with(array|string $relations)
     * @method _IH_DatabaseBackupSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DatabaseBackupSetting_C|DatabaseBackupSetting[] all()
     * @mixin _IH_DatabaseBackupSetting_QB
     */
    class DatabaseBackupSetting extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $short_name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Alumni_C|Alumni[] $alumni
     * @property-read int $alumni_count
     * @method HasMany|_IH_Alumni_QB alumni()
     * @method static _IH_Department_QB onWriteConnection()
     * @method _IH_Department_QB newQuery()
     * @method static _IH_Department_QB on(null|string $connection = null)
     * @method static _IH_Department_QB query()
     * @method static _IH_Department_QB with(array|string $relations)
     * @method _IH_Department_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Department_C|Department[] all()
     * @foreignLinks id,\App\Models\Alumni,department_id
     * @mixin _IH_Department_QB
     */
    class Department extends Model {}

    /**
     * @property int $id
     * @property string|null $category
     * @property string|null $slug
     * @property string|null $subject
     * @property string|null $body
     * @property int $default
     * @property int $status
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_EmailTemplate_QB onWriteConnection()
     * @method _IH_EmailTemplate_QB newQuery()
     * @method static _IH_EmailTemplate_QB on(null|string $connection = null)
     * @method static _IH_EmailTemplate_QB query()
     * @method static _IH_EmailTemplate_QB with(array|string $relations)
     * @method _IH_EmailTemplate_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EmailTemplate_C|EmailTemplate[] all()
     * @mixin _IH_EmailTemplate_QB
     */
    class EmailTemplate extends Model {}

    /**
     * @property int $id
     * @property int $event_category_id
     * @property string $title
     * @property string $slug
     * @property int $thumbnail
     * @property Carbon $date
     * @property int $type
     * @property string $location
     * @property float $price
     * @property int $number_of_ticket
     * @property int $number_of_ticket_left
     * @property string|null $description
     * @property int $user_id
     * @property int $status
     * @property int|null $approved_by
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $ticket_image
     * @property User $author
     * @method BelongsTo|_IH_User_QB author()
     * @property EventCategory $category
     * @method BelongsTo|_IH_EventCategory_QB category()
     * @property _IH_EventTicket_C|EventTicket[] $eventTicket
     * @property-read int $event_ticket_count
     * @method HasMany|_IH_EventTicket_QB eventTicket()
     * @property _IH_Payment_C|Payment[] $payments
     * @property-read int $payments_count
     * @method MorphToMany|_IH_Payment_QB payments()
     * @method static _IH_Event_QB onWriteConnection()
     * @method _IH_Event_QB newQuery()
     * @method static _IH_Event_QB on(null|string $connection = null)
     * @method static _IH_Event_QB query()
     * @method static _IH_Event_QB with(array|string $relations)
     * @method _IH_Event_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Event_C|Event[] all()
     * @ownLinks event_category_id,\App\Models\EventCategory,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\App\Models\EventTicket,event_id
     * @mixin _IH_Event_QB
     */
    class Event extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Event_C|Event[] $event
     * @property-read int $event_count
     * @method HasMany|_IH_Event_QB event()
     * @method static _IH_EventCategory_QB onWriteConnection()
     * @method _IH_EventCategory_QB newQuery()
     * @method static _IH_EventCategory_QB on(null|string $connection = null)
     * @method static _IH_EventCategory_QB query()
     * @method static _IH_EventCategory_QB with(array|string $relations)
     * @method _IH_EventCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EventCategory_C|EventCategory[] all()
     * @foreignLinks id,\App\Models\Event,event_category_id
     * @mixin _IH_EventCategory_QB
     */
    class EventCategory extends Model {}

    /**
     * @property int $id
     * @property int $event_id
     * @property int $user_id
     * @property string $ticket_number
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Event $event
     * @method BelongsTo|_IH_Event_QB event()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_EventTicket_QB onWriteConnection()
     * @method _IH_EventTicket_QB newQuery()
     * @method static _IH_EventTicket_QB on(null|string $connection = null)
     * @method static _IH_EventTicket_QB query()
     * @method static _IH_EventTicket_QB with(array|string $relations)
     * @method _IH_EventTicket_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EventTicket_C|EventTicket[] all()
     * @ownLinks event_id,\App\Models\Event,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_EventTicket_QB
     */
    class EventTicket extends Model {}

    /**
     * @property int $id
     * @property string $file_type
     * @property string $storage_type
     * @property string $original_name
     * @property string $file_name
     * @property int|null $user_id
     * @property string $path
     * @property string $extension
     * @property string $size
     * @property string|null $external_link
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_FileManager_QB onWriteConnection()
     * @method _IH_FileManager_QB newQuery()
     * @method static _IH_FileManager_QB on(null|string $connection = null)
     * @method static _IH_FileManager_QB query()
     * @method static _IH_FileManager_QB with(array|string $relations)
     * @method _IH_FileManager_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FileManager_C|FileManager[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_FileManager_QB
     */
    class FileManager extends Model {}

    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string|null $image
     * @property int $status
     * @property int $mode
     * @property string|null $url
     * @property string|null $key
     * @property string|null $secret
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property-read string $icon attribute
     * @method static _IH_Gateway_QB onWriteConnection()
     * @method _IH_Gateway_QB newQuery()
     * @method static _IH_Gateway_QB on(null|string $connection = null)
     * @method static _IH_Gateway_QB query()
     * @method static _IH_Gateway_QB with(array|string $relations)
     * @method _IH_Gateway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Gateway_C|Gateway[] all()
     * @foreignLinks id,\App\Models\GatewayCurrency,gateway_id|id,\App\Models\Bank,gateway_id|id,\App\Models\Payment,gateway_id
     * @mixin _IH_Gateway_QB
     */
    class Gateway extends Model {}

    /**
     * @property int $id
     * @property int $gateway_id
     * @property string $currency
     * @property float $conversion_rate
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property-read $symbol attribute
     * @method static _IH_GatewayCurrency_QB onWriteConnection()
     * @method _IH_GatewayCurrency_QB newQuery()
     * @method static _IH_GatewayCurrency_QB on(null|string $connection = null)
     * @method static _IH_GatewayCurrency_QB query()
     * @method static _IH_GatewayCurrency_QB with(array|string $relations)
     * @method _IH_GatewayCurrency_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GatewayCurrency_C|GatewayCurrency[] all()
     * @ownLinks gateway_id,\App\Models\Gateway,id
     * @mixin _IH_GatewayCurrency_QB
     */
    class GatewayCurrency extends Model {}

    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string $compensation_n_benefits
     * @property string $salary
     * @property int $company_logo
     * @property string $location
     * @property string $post_link
     * @property Carbon $application_deadline
     * @property string $job_responsibility
     * @property string $job_context
     * @property string $educational_requirements
     * @property string|null $additional_requirements
     * @property int $user_id
     * @property int $employee_status
     * @property int $status
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_JobPost_QB onWriteConnection()
     * @method _IH_JobPost_QB newQuery()
     * @method static _IH_JobPost_QB on(null|string $connection = null)
     * @method static _IH_JobPost_QB query()
     * @method static _IH_JobPost_QB with(array|string $relations)
     * @method _IH_JobPost_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobPost_C|JobPost[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_JobPost_QB
     */
    class JobPost extends Model {}

    /**
     * @property int $id
     * @property string $language
     * @property string $iso_code
     * @property int|null $flag_id
     * @property int|null $font
     * @property int|null $rtl
     * @property int $status
     * @property int|null $default
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property-read $flag attribute
     * @method static _IH_Language_QB onWriteConnection()
     * @method _IH_Language_QB newQuery()
     * @method static _IH_Language_QB on(null|string $connection = null)
     * @method static _IH_Language_QB query()
     * @method static _IH_Language_QB with(array|string $relations)
     * @method _IH_Language_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Language_C|Language[] all()
     * @mixin _IH_Language_QB
     */
    class Language extends Model {}

    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property int $badge
     * @property float $price
     * @property int $duration_type
     * @property int $duration
     * @property int $status
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Payment_C|Payment[] $payments
     * @property-read int $payments_count
     * @method MorphToMany|_IH_Payment_QB payments()
     * @property _IH_UserMembershipPlan_C|UserMembershipPlan[] $userMembershipPlans
     * @property-read int $user_membership_plans_count
     * @method HasMany|_IH_UserMembershipPlan_QB userMembershipPlans()
     * @method static _IH_Membership_QB onWriteConnection()
     * @method _IH_Membership_QB newQuery()
     * @method static _IH_Membership_QB on(null|string $connection = null)
     * @method static _IH_Membership_QB query()
     * @method static _IH_Membership_QB with(array|string $relations)
     * @method _IH_Membership_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Membership_C|Membership[] all()
     * @mixin _IH_Membership_QB
     */
    class Membership extends Model {}

    /**
     * @property int $id
     * @property string $uuid
     * @property string|null $slug
     * @property string|null $page_name
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property string|null $meta_keyword
     * @property string|null $og_image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Meta_QB onWriteConnection()
     * @method _IH_Meta_QB newQuery()
     * @method static _IH_Meta_QB on(null|string $connection = null)
     * @method static _IH_Meta_QB query()
     * @method static _IH_Meta_QB with(array|string $relations)
     * @method _IH_Meta_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Meta_C|Meta[] all()
     * @mixin _IH_Meta_QB
     */
    class Meta extends Model {}

    /**
     * @property int $id
     * @property int $news_category_id
     * @property string $title
     * @property string $slug
     * @property string $details
     * @property int|null $image
     * @property int $status
     * @property int $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property User $author
     * @method BelongsTo|_IH_User_QB author()
     * @property NewsCategory $category
     * @method BelongsTo|_IH_NewsCategory_QB category()
     * @property _IH_NewsTag_C|NewsTag[] $tags
     * @property-read int $tags_count
     * @method BelongsToMany|_IH_NewsTag_QB tags()
     * @method static _IH_News_QB onWriteConnection()
     * @method _IH_News_QB newQuery()
     * @method static _IH_News_QB on(null|string $connection = null)
     * @method static _IH_News_QB query()
     * @method static _IH_News_QB with(array|string $relations)
     * @method _IH_News_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_News_C|News[] all()
     * @ownLinks news_category_id,\App\Models\NewsCategory,id
     * @foreignLinks
     * @mixin _IH_News_QB
     */
    class News extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_News_C|News[] $news
     * @property-read int $news_count
     * @method HasMany|_IH_News_QB news()
     * @method static _IH_NewsCategory_QB onWriteConnection()
     * @method _IH_NewsCategory_QB newQuery()
     * @method static _IH_NewsCategory_QB on(null|string $connection = null)
     * @method static _IH_NewsCategory_QB query()
     * @method static _IH_NewsCategory_QB with(array|string $relations)
     * @method _IH_NewsCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_NewsCategory_C|NewsCategory[] all()
     * @foreignLinks id,\App\Models\News,news_category_id
     * @mixin _IH_NewsCategory_QB
     */
    class NewsCategory extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_News_C|News[] $news
     * @property-read int $news_count
     * @method BelongsToMany|_IH_News_QB news()
     * @method static _IH_NewsTag_QB onWriteConnection()
     * @method _IH_NewsTag_QB newQuery()
     * @method static _IH_NewsTag_QB on(null|string $connection = null)
     * @method static _IH_NewsTag_QB query()
     * @method static _IH_NewsTag_QB with(array|string $relations)
     * @method _IH_NewsTag_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_NewsTag_C|NewsTag[] all()
     * @mixin _IH_NewsTag_QB
     */
    class NewsTag extends Model {}

    /**
     * @property int $id
     * @property int $notice_category_id
     * @property string $title
     * @property string $slug
     * @property string $details
     * @property int|null $image
     * @property int $status
     * @property int $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property NoticeCategory $category
     * @method BelongsTo|_IH_NoticeCategory_QB category()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Notice_QB onWriteConnection()
     * @method _IH_Notice_QB newQuery()
     * @method static _IH_Notice_QB on(null|string $connection = null)
     * @method static _IH_Notice_QB query()
     * @method static _IH_Notice_QB with(array|string $relations)
     * @method _IH_Notice_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Notice_C|Notice[] all()
     * @ownLinks notice_category_id,\App\Models\NoticeCategory,id
     * @mixin _IH_Notice_QB
     */
    class Notice extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Notice_C|Notice[] $notice
     * @property-read int $notice_count
     * @method HasMany|_IH_Notice_QB notice()
     * @method static _IH_NoticeCategory_QB onWriteConnection()
     * @method _IH_NoticeCategory_QB newQuery()
     * @method static _IH_NoticeCategory_QB on(null|string $connection = null)
     * @method static _IH_NoticeCategory_QB query()
     * @method static _IH_NoticeCategory_QB with(array|string $relations)
     * @method _IH_NoticeCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_NoticeCategory_C|NoticeCategory[] all()
     * @foreignLinks id,\App\Models\Notice,notice_category_id
     * @mixin _IH_NoticeCategory_QB
     */
    class NoticeCategory extends Model {}

    /**
     * @property int $id
     * @property int|null $user_id
     * @property string|null $title
     * @property string|null $body
     * @property string|null $link
     * @property int $view_status
     * @property int $status
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Notification_QB onWriteConnection()
     * @method _IH_Notification_QB newQuery()
     * @method static _IH_Notification_QB on(null|string $connection = null)
     * @method static _IH_Notification_QB query()
     * @method static _IH_Notification_QB with(array|string $relations)
     * @method _IH_Notification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Notification_C|Notification[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\App\Models\NotificationSeen,notification_id
     * @mixin _IH_Notification_QB
     */
    class Notification extends Model {}

    /**
     * @property int $id
     * @property int|null $user_id
     * @property int|null $notification_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_NotificationSeen_QB onWriteConnection()
     * @method _IH_NotificationSeen_QB newQuery()
     * @method static _IH_NotificationSeen_QB on(null|string $connection = null)
     * @method static _IH_NotificationSeen_QB query()
     * @method static _IH_NotificationSeen_QB with(array|string $relations)
     * @method _IH_NotificationSeen_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_NotificationSeen_C|NotificationSeen[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|notification_id,\Illuminate\Notifications\DatabaseNotification,id
     * @mixin _IH_NotificationSeen_QB
     */
    class NotificationSeen extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Alumni_C|Alumni[] $alumni
     * @property-read int $alumni_count
     * @method HasMany|_IH_Alumni_QB alumni()
     * @method static _IH_PassingYear_QB onWriteConnection()
     * @method _IH_PassingYear_QB newQuery()
     * @method static _IH_PassingYear_QB on(null|string $connection = null)
     * @method static _IH_PassingYear_QB query()
     * @method static _IH_PassingYear_QB with(array|string $relations)
     * @method _IH_PassingYear_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PassingYear_C|PassingYear[] all()
     * @foreignLinks id,\App\Models\Alumni,passing_year_id
     * @mixin _IH_PassingYear_QB
     */
    class PassingYear extends Model {}

    /**
     * @property int $id
     * @property string $uuid
     * @property string $paymentable_id
     * @property string $paymentable_type
     * @property int $gateway_id
     * @property string|null $paymentId
     * @property string|null $tnxId
     * @property int $user_id
     * @property int|null $bank_id
     * @property int|null $deposit_slip
     * @property float $sub_total
     * @property float $tax
     * @property string|null $system_currency
     * @property string|null $payment_currency
     * @property float $conversion_rate
     * @property float $grand_total_with_conversation_rate
     * @property float $grand_total
     * @property string|null $payment_details
     * @property string|null $gateway_callback_details
     * @property Carbon|null $payment_time
     * @property int $payment_status
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Bank|null $bank
     * @method BelongsTo|_IH_Bank_QB bank()
     * @property Gateway $gateway
     * @method BelongsTo|_IH_Gateway_QB gateway()
     * @property Model $paymentable
     * @method MorphTo paymentable()
     * @property _IH_Transaction_C|Transaction[] $transaction
     * @property-read int $transaction_count
     * @method HasMany|_IH_Transaction_QB transaction()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Payment_QB onWriteConnection()
     * @method _IH_Payment_QB newQuery()
     * @method static _IH_Payment_QB on(null|string $connection = null)
     * @method static _IH_Payment_QB query()
     * @method static _IH_Payment_QB with(array|string $relations)
     * @method _IH_Payment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Payment_C|Payment[] all()
     * @ownLinks gateway_id,\App\Models\Gateway,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|bank_id,\App\Models\Bank,id
     * @foreignLinks id,\App\Models\Transaction,payment_id
     * @mixin _IH_Payment_QB
     */
    class Payment extends Model {}

    /**
     * @property int $id
     * @property string $slug
     * @property string $body
     * @property int $status
     * @property int $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property User $author
     * @method BelongsTo|_IH_User_QB author()
     * @property _IH_PostComment_C|PostComment[] $comments
     * @property-read int $comments_count
     * @method HasMany|_IH_PostComment_QB comments()
     * @property _IH_User_C|User[] $likes
     * @property-read int $likes_count
     * @method BelongsToMany|_IH_User_QB likes()
     * @property _IH_PostMedia_C|PostMedia[] $media
     * @property-read int $media_count
     * @method HasMany|_IH_PostMedia_QB media()
     * @property _IH_PostComment_C|PostComment[] $replies
     * @property-read int $replies_count
     * @method HasMany|_IH_PostComment_QB replies()
     * @method static _IH_Post_QB onWriteConnection()
     * @method _IH_Post_QB newQuery()
     * @method static _IH_Post_QB on(null|string $connection = null)
     * @method static _IH_Post_QB query()
     * @method static _IH_Post_QB with(array|string $relations)
     * @method _IH_Post_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Post_C|Post[] all()
     * @foreignLinks id,\App\Models\PostComment,post_id|id,\App\Models\PostMedia,post_id
     * @mixin _IH_Post_QB
     */
    class Post extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property int $post_id
     * @property int|null $parent_id
     * @property string $body
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Post $post
     * @method BelongsTo|_IH_Post_QB post()
     * @property User $repliedTo
     * @method BelongsTo|_IH_User_QB repliedTo()
     * @property _IH_PostComment_C|PostComment[] $replies
     * @property-read int $replies_count
     * @method HasMany|_IH_PostComment_QB replies()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_PostComment_QB onWriteConnection()
     * @method _IH_PostComment_QB newQuery()
     * @method static _IH_PostComment_QB on(null|string $connection = null)
     * @method static _IH_PostComment_QB query()
     * @method static _IH_PostComment_QB with(array|string $relations)
     * @method _IH_PostComment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PostComment_C|PostComment[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|post_id,\App\Models\Post,id
     * @mixin _IH_PostComment_QB
     */
    class PostComment extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property int $post_id
     * @property int $file
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property FileManager $file_manager
     * @method BelongsTo|_IH_FileManager_QB file_manager()
     * @property Post $post
     * @method BelongsTo|_IH_Post_QB post()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_PostMedia_QB onWriteConnection()
     * @method _IH_PostMedia_QB newQuery()
     * @method static _IH_PostMedia_QB on(null|string $connection = null)
     * @method static _IH_PostMedia_QB query()
     * @method static _IH_PostMedia_QB with(array|string $relations)
     * @method _IH_PostMedia_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PostMedia_C|PostMedia[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|post_id,\App\Models\Post,id
     * @mixin _IH_PostMedia_QB
     */
    class PostMedia extends Model {}

    /**
     * @property int $id
     * @property string $option_key
     * @property string|null $option_value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Setting_QB onWriteConnection()
     * @method _IH_Setting_QB newQuery()
     * @method static _IH_Setting_QB on(null|string $connection = null)
     * @method static _IH_Setting_QB query()
     * @method static _IH_Setting_QB with(array|string $relations)
     * @method _IH_Setting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Setting_C|Setting[] all()
     * @mixin _IH_Setting_QB
     */
    class Setting extends Model {}

    /**
     * @property int $id
     * @property string $uuid
     * @property int $user_id
     * @property int $payment_id
     * @property int $type
     * @property string $tnxId
     * @property float $amount
     * @property string $purpose
     * @property Carbon $payment_time
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $payment_method
     * @property int|null $reference_id
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Transaction_QB onWriteConnection()
     * @method _IH_Transaction_QB newQuery()
     * @method static _IH_Transaction_QB on(null|string $connection = null)
     * @method static _IH_Transaction_QB query()
     * @method static _IH_Transaction_QB with(array|string $relations)
     * @method _IH_Transaction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Transaction_C|Transaction[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|payment_id,\App\Models\Payment,id
     * @mixin _IH_Transaction_QB
     */
    class Transaction extends Model {}

    /**
     * @property int $id
     * @property string $uuid
     * @property string $name
     * @property string|null $nick_name
     * @property string $email
     * @property string $mobile
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property int|null $image
     * @property int $role
     * @property int $email_verification_status
     * @property int $phone_verification_status
     * @property int $google_auth_status
     * @property string|null $google2fa_secret
     * @property string|null $google_id
     * @property string|null $facebook_id
     * @property string|null $verify_token
     * @property int|null $otp
     * @property Carbon|null $otp_expiry
     * @property int $show_email_in_public
     * @property int $show_phone_in_public
     * @property int|null $created_by
     * @property int $status
     * @property string|null $remember_token
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon $last_seen
     * @property Alumni $alumni
     * @method HasOne|_IH_Alumni_QB alumni()
     * @property _IH_AuthenticationLog_C|AuthenticationLog[] $authentications
     * @property-read int $authentications_count
     * @method MorphToMany|_IH_AuthenticationLog_QB authentications()
     * @property UserMembershipPlan $currentMembership
     * @method HasOne|_IH_UserMembershipPlan_QB currentMembership()
     * @property _IH_UserInstitution_C|UserInstitution[] $institutions
     * @property-read int $institutions_count
     * @method HasMany|_IH_UserInstitution_QB institutions()
     * @property _IH_AuthenticationLog_C|AuthenticationLog[] $lastLoginAt
     * @property-read int $last_login_at_count
     * @method MorphToMany|_IH_AuthenticationLog_QB lastLoginAt()
     * @property _IH_AuthenticationLog_C|AuthenticationLog[] $lastLoginIp
     * @property-read int $last_login_ip_count
     * @method MorphToMany|_IH_AuthenticationLog_QB lastLoginIp()
     * @property _IH_AuthenticationLog_C|AuthenticationLog[] $lastSuccessfulLoginAt
     * @property-read int $last_successful_login_at_count
     * @method MorphToMany|_IH_AuthenticationLog_QB lastSuccessfulLoginAt()
     * @property _IH_AuthenticationLog_C|AuthenticationLog[] $lastSuccessfulLoginIp
     * @property-read int $last_successful_login_ip_count
     * @method MorphToMany|_IH_AuthenticationLog_QB lastSuccessfulLoginIp()
     * @property AuthenticationLog $latestAuthentication
     * @method MorphToMany|_IH_AuthenticationLog_QB latestAuthentication()
     * @property _IH_Chat_C|Chat[] $messages
     * @property-read int $messages_count
     * @method HasMany|_IH_Chat_QB messages()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property _IH_AuthenticationLog_C|AuthenticationLog[] $previousLoginAt
     * @property-read int $previous_login_at_count
     * @method MorphToMany|_IH_AuthenticationLog_QB previousLoginAt()
     * @property _IH_AuthenticationLog_C|AuthenticationLog[] $previousLoginIp
     * @property-read int $previous_login_ip_count
     * @method MorphToMany|_IH_AuthenticationLog_QB previousLoginIp()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @property _IH_Chat_C|Chat[] $unseen_message
     * @property-read int $unseen_message_count
     * @method HasMany|_IH_Chat_QB unseen_message()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @foreignLinks id,\App\Models\Alumni,user_id|id,\App\Models\UserInstitution,user_id|id,\App\Models\FileManager,user_id|id,\App\Models\Payment,user_id|id,\Illuminate\Notifications\DatabaseNotification,user_id|id,\App\Models\UserMembershipPlan,user_id|id,\App\Models\Event,user_id|id,\App\Models\EventTicket,user_id|id,\App\Models\PostComment,user_id|id,\App\Models\PostMedia,user_id|id,\App\Models\JobPost,user_id|id,\App\Models\NotificationSeen,user_id|id,\App\Models\Transaction,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(array|callable|int|null $count = null, array|callable $state = [])
     */
    class User extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property string $degree
     * @property string $passing_year
     * @property string $institute
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserInstitution_QB onWriteConnection()
     * @method _IH_UserInstitution_QB newQuery()
     * @method static _IH_UserInstitution_QB on(null|string $connection = null)
     * @method static _IH_UserInstitution_QB query()
     * @method static _IH_UserInstitution_QB with(array|string $relations)
     * @method _IH_UserInstitution_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserInstitution_C|UserInstitution[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_UserInstitution_QB
     */
    class UserInstitution extends Model {}

    /**
     * @property int $id
     * @property int $membership_id
     * @property int $user_id
     * @property Carbon $expired_date
     * @property int $status
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Membership $membership
     * @method BelongsTo|_IH_Membership_QB membership()
     * @property _IH_Membership_C|Membership[] $memberships
     * @property-read int $memberships_count
     * @method HasMany|_IH_Membership_QB memberships()
     * @property User $users
     * @method BelongsTo|_IH_User_QB users()
     * @method static _IH_UserMembershipPlan_QB onWriteConnection()
     * @method _IH_UserMembershipPlan_QB newQuery()
     * @method static _IH_UserMembershipPlan_QB on(null|string $connection = null)
     * @method static _IH_UserMembershipPlan_QB query()
     * @method static _IH_UserMembershipPlan_QB with(array|string $relations)
     * @method _IH_UserMembershipPlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserMembershipPlan_C|UserMembershipPlan[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_UserMembershipPlan_QB
     */
    class UserMembershipPlan extends Model {}
}
